-- Fichero SFSQLins.sql
-- Modificado para Oracle 8.1.5
-- ************************************************************************
-- ***  # INSTALACIN del SERVIDOR FSQL (SFSQL):                        ***
-- ***      a) Crear y rellenar tablas de los Analizadores              ***
-- ***      b) Instalar los paquetes PL/SQL: FSQL_PKG, FSQL_FUNCTIONS   ***
-- ***                                       y FSQL_FUNCTIONS2.         ***
-- ************************************************************************

-- --------------------------------------------------------------------------------------------
-- Tablas del SERVIDOR FSQL:
-- TABLA            LEIDA POR       ESCRITA POR     OWNER   Contenido
-- ----------------------------------------------------------------------------------------------
-- T_TRANSI             A. Lxico       CONSTANTE       SYS Transiciones del Autmata
-- RESERVADAS           A. Lxico       CONSTANTE       SYS Palabras Reservadas
-- TABLA_SINTAX         A. Sintctico   CONSTANTE       SYS Transiciones de la Gramtica
-- PRODUCCIONES         A. Sintctico   CONSTANTE       SYS Producciones de la Gramtica
-- FSQL_ALL_ERRORS      --          --          SYS Mensajes de los Errores
-- FSQL_ALL_QUERIES     --          --          SYS Consultas: FSQL y su traduccin SQL
-- Vista FSQL_ERRORS    Cliente FSQL    Lx/Sint/Sem    SYS Vista sobre FSQL_ALL_ERRORS particular
-- Vista FSQL_QUERY     Sint/Sem/Cliente    Lx/Sint/Sem    SYS Vista sobre FSQL_ALL_QUERIES particular
-- FSQL_ALL_INFO        --          --          SYS Informacin gral. y opciones de usuarios
-- Vista FSQL_INFO      Usuario/Cliente Servidor FSQL   SYS Vista sobre FSQL_ALL_INFO particular
-- Vista FSQL_OPTIONS   A. Semntico    Usuario/Cliente SYS Vista sobre FSQL_ALL_INFO particular
-- FSQL_STATS           Usuario/Cliente   Servidor FSQLl    SYS   Control de accesos para estadsticas
-- --------------------------------------------------------------------------------------------

-- Para que salgan los mensajes (de put_line) al instalar desde FSQL*Plus:
set serveroutput on
-- Para que salgan (o no) las ordenes a ejecutar: set echo on
set echo off
-- Para que no salgan los mensajes cuando todo va bien (los errores si salen):
set feedback off

exec dbms_output.put_line('>>>>');
exec dbms_output.put_line('>>>> *************************************** <<<<');
exec dbms_output.put_line('>>>> **** INSTALACIN del SERVIDOR FSQL **** <<<<');
exec dbms_output.put_line('>>>> *************************************** <<<< by J. Galindo G.');
exec dbms_output.put_line('>>>>');
exec dbms_output.put_line('>>>> NOTAS:');
exec dbms_output.put_line('>>>>   - Es requisito indispensable que est instalado FIRST (tablas de la FMB...).');
exec dbms_output.put_line('>>>>   - No importa si se producen errores al intentar borrar');
exec dbms_output.put_line('>>>>     objetos que no existan (tablas ORA-00942...).');
exec dbms_output.put_line('>>>>   - Cualquier otro error podr impedir la correcta ejecucin del Servidor FSQL.');
exec dbms_output.put_line('>>>>     En ese caso revise el cdigo del error y el lugar donde ha ocurrido.');
exec dbms_output.put_line('>>>>');
exec dbms_output.put_line('>>>> Borrando y Creando tablas, vistas y sinnimos del Servidor FSQL...');
-- **********************************************************
-- ***  TABLAS de FSQL usadas por todos los Analizadores  ***
-- ***  Estas dos tablas (FSQL_*) sern las nicas a las  ***
-- ***  acceda el CLIENTE FSQL directamente.              ***
-- **********************************************************
-- TABLA de ERRORES cometidos, ordenados cronolgicamente por INDICE (para cada sesin):
-- Primero los lxicos, luego sintcticos y por ltimo los semnticos
-- Cada sessin podr tener distintos errores, por lo que la sessin se identifica con SESSIONID.
DROP   TABLE FSQL_ALL_ERRORS;
CREATE TABLE FSQL_ALL_ERRORS (
  SESSIONID NUMBER         NOT NULL, -- Identificador de la sessin: USERENV('SESSIONID')
  INDICE    NUMBER(2)      NOT NULL, -- Nmero de orden del error
  MSG_ERROR VARCHAR2(2000) NOT NULL, -- Mensaje del error
  PRIMARY KEY (SESSIONID,INDICE));

-- TABLA con la LISTA de TOKENS de la cadena de entrada
DROP   TABLE FSQL_ALL_QUERIES;
CREATE TABLE FSQL_ALL_QUERIES (
  SESSIONID NUMBER     NOT NULL, -- Identificador de la sessin: USERENV('SESSIONID')
  INDICE   NUMBER (10) NOT NULL, -- Nmero de token (empezando por el 0)
  POSICION NUMBER (10) NOT NULL, -- Posicin del final del token (por si se producen errores ah)
  NOMBRE   VARCHAR2(100)NOT NULL,-- Nombre del token
  ATRIBUTO VARCHAR2(4000), -- Token ledo de la entrada. Si es cadena/texto podra tener hasta
                           -- 2000 caracteres (max long aceptada en una columna VARCHAR2 SQL)
  PRIMARY KEY (SESSIONID,INDICE));

-- ********************** Tabla con INFORMACIN para ESTADSTICAS
DROP   TABLE FSQL_STATS;
CREATE TABLE FSQL_STATS (
  EVENTO VARCHAR2(30) PRIMARY KEY,
  NUM    NUMBER  (38) NOT NULL);
  -- EVENTO es el Evento que se contabiliza y NUM es el Nmero de veces que ocurre el EVENTO:
  -- 1. 'ACCESOS_PARA_TRADUCCIONES'   Traducciones hechas (con o sin errores)
  -- 2. 'TOTAL_ERRORES_COMETIDOS'     Errores cometidos en todas las traducciones
  -- 3. 'ACCESOS_SIN_ERRORES'         Traducciones hechas sin encontrar errores
  -- 4. 'TIEMPO_TOTAL_ACCESOS'        Tiempo total empleado en todas las traducciones
  -- 5. 'TIEMPO_ACCESOS_SIN_ERRORES'  Tiempo empleado en las traducciones sin errores
  -- 6. 'EJECUCIONES_FSQL_FIN'        Veces que se ha ejecutado FSQL_FIN
  -- 7. 'ULTIMO_SESSIONID'            Ultima sesin que accedi al Servidor
  -- 8. 'CAMBIOS_DE_SESSIONID'        Nmero de veces que cambia de una a otra sesin
  -- 9. 'TOTAL_PAQUETE_FSQL_PKG'      Nmero de cargas del paquete FSQL_PKG
  --10. 'TIEMPO_ULTIMA_TRADUCCION'    Tiempo empleado en la ltima traduccin (independiente del usuario)
  --11. 'ERRORES_ULTIMA_TRADUCCION'   Errores en la ltima traduccin (independiente del usuario)

-- Inserciones e inicializaciones para los EVENTOS contabilizados:
insert into FSQL_STATS VALUES('ACCESOS_PARA_TRADUCCIONES',0);
insert into FSQL_STATS VALUES('TOTAL_ERRORES_COMETIDOS',0);
insert into FSQL_STATS VALUES('ACCESOS_SIN_ERRORES',0);
insert into FSQL_STATS VALUES('TIEMPO_TOTAL_ACCESOS',0);
insert into FSQL_STATS VALUES('TIEMPO_ACCESOS_SIN_ERRORES',0);
insert into FSQL_STATS VALUES('EJECUCIONES_FSQL_FIN',0);
insert into FSQL_STATS VALUES('ULTIMO_SESSIONID',0);
insert into FSQL_STATS VALUES('CAMBIOS_DE_SESSIONID',0);
insert into FSQL_STATS VALUES('TOTAL_PAQUETE_FSQL_PKG',0);
insert into FSQL_STATS VALUES('TIEMPO_ULTIMA_TRADUCCION',0);
insert into FSQL_STATS VALUES('ERRORES_ULTIMA_TRADUCCION',0);

-- ********************** Tabla con INFORMACIN y OPCIONES sobre FSQL **********************
DROP   TABLE FSQL_ALL_INFO;
CREATE TABLE FSQL_ALL_INFO (
  OWNER  VARCHAR2(30),  -- Identificador del USUARIO de la opcin, 'FSQL SERVER' si es para todos
  OPCION VARCHAR2(30),  -- Opcin que se establece al valor VALOR
  VALOR  VARCHAR2(100), -- Valor para la opcin OPCION
  PRIMARY KEY (OWNER,OPCION));
-- Vista con la informacin general, para todos los usuarios:
create or replace view FSQL_INFO AS
  SELECT OPCION, VALOR FROM FSQL_ALL_INFO WHERE OWNER='FSQL SERVER';
---------------- VALORES QUE NO PUEDEN MODIFICAR LOS USUARIOS: INFORMACIN GENERAL (OWNER=NULL)
-- OPCION             Significado de VALUE
------------------------------------------
-- VERSION_SFSQL      Versin del actual Servidor FSQL
-- FECHA_INSTALACION  Fecha de instalacin del Servidor FSQL
-- FECHA_ULTIMO_USO   Fecha del ltimo uso del Servidor FSQL
-- FECHA_ULTIMO_FIN   Fecha del ltimo uso de la funcin FSQL_FIN (paquete FSQL_PKG)
-- DBA_INSTALLER      Superusuario DBA que instala el Servidor FSQL

--*************************************************************Versin actual: 1.2
insert into FSQL_ALL_INFO VALUES ('FSQL SERVER','VERSION_SFSQL','1.2');
insert into FSQL_ALL_INFO VALUES ('FSQL SERVER','FECHA_INSTALACION',
  to_char(SYSDATE,'DD-MM-YYYY, HH24:MI'));
insert into FSQL_ALL_INFO VALUES ('FSQL SERVER','FECHA_ULTIMO_USO','No usado');
insert into FSQL_ALL_INFO VALUES ('FSQL SERVER','FECHA_ULTIMO_FIN','No usado');
insert into FSQL_ALL_INFO VALUES ('FSQL SERVER','DBA_INSTALLER',USER);

---------------- VALORES PROPIOS de cada USUARIO (QUE PUEDEN MODIFICAR)
-- OPCION  Significado de VALUE
-------------------------------
-- NOT     Funcin a aplicar con el CDEG en este operador: NOT a. Por defecto 1-a
-- AND     Funcin a aplicar con el CDEG en este operador: a AND b. Por defecto LEAST(a,b)
-- OR      Funcin a aplicar con el CDEG en este operador: a OR b. Por defecto GREATEST(a,b)
-- NUM_ERRORES
--         Indica el nmero de errores FSQL localizados en la ltima traduccin
-- TIEMPO_TRADUCCION
--         Tiempo empleado por el Servidor FSQL en la ltima consulta del usuario
--         (hay que tener en cuenta si hubo errores: NUM_ERRORES)
-- TRATA_FUZZY_ATRIB
--         Tratamiento que se le da a los atributos difusos cuando estos estn fuera de los
--         lugares normales (select_list, argumento de CDEG o en condiciones). Por ejemplo,
--         cuando estn en expresiones, argumento de otras funciones, en ORDER BY...
--         Valores vlidos que el usuario puede utilizar:
--            ERROR      --> Genera un error
--            TIPO_VALOR --> Utiliza el tipo del valor del atributo: Tipo NUMBER(1)
--                           (concatenar 'T' al nombre del atributo)
--            REPRESENT  --> Utiliza la representacin grfica del atributo: Tipo VARCHAR2
--                           (opcin por defecto)

-- Crear VISTAS particulares para cada usuario:
create or replace view FSQL_ERRORS AS
  SELECT * FROM FSQL_ALL_ERRORS  WHERE SESSIONID=USERENV('SESSIONID');
create or replace view FSQL_QUERY AS
  SELECT * FROM FSQL_ALL_QUERIES WHERE SESSIONID=USERENV('SESSIONID');
create or replace view FSQL_OPTIONS AS
  SELECT * FROM FSQL_ALL_INFO WHERE OWNER=USER;
-- Ejemplos de inserciones en FSQL_OPTIONS:
--  INSERT INTO FSQL_OPTIONS values (USER,'NOT','LukaNOT');
--  INSERT INTO FSQL_OPTIONS values (USER,'AND','LukaAND');
--  INSERT INTO FSQL_OPTIONS values (USER,'OR','LukaOR');

-- Crear SINNIMOS para que no haya que especificar SYS.FSQL_*:
drop public synonym FSQL_ERRORS;
drop public synonym FSQL_QUERY;
drop public synonym FSQL_STATS;
drop public synonym FSQL_INFO;
drop public synonym FSQL_OPTIONS;
CREATE PUBLIC SYNONYM FSQL_ERRORS  FOR FSQL_ERRORS;
CREATE PUBLIC SYNONYM FSQL_QUERY   FOR FSQL_QUERY;
CREATE PUBLIC SYNONYM FSQL_STATS   FOR FSQL_STATS;
CREATE PUBLIC SYNONYM FSQL_INFO    FOR FSQL_INFO;
CREATE PUBLIC SYNONYM FSQL_OPTIONS FOR FSQL_OPTIONS;
-- Dar privilegios de acceso:
GRANT SELECT                      on FSQL_INFO    to PUBLIC;
GRANT SELECT                      on FSQL_STATS   to PUBLIC;
GRANT SELECT,INSERT,DELETE,UPDATE on FSQL_OPTIONS to PUBLIC;
GRANT SELECT,INSERT,DELETE,UPDATE on FSQL_ERRORS  to PUBLIC;
GRANT SELECT,INSERT,DELETE,UPDATE on FSQL_QUERY   to PUBLIC;

/*****************************************/
/***  TABLAS para el ANALISIS LEXICO   ***/
/*****************************************/

-- TABLA de PALABRAS RESERVADAS y sus permisos
DROP   TABLE RESERVADAS;
CREATE TABLE RESERVADAS(
  palabra     varchar(20) NOT NULL,
  primary key (palabra));
drop public synonym RESERVADAS;
CREATE PUBLIC SYNONYM RESERVADAS FOR RESERVADAS;
GRANT SELECT on RESERVADAS to PUBLIC;

-- INSERCIN en TABLA RESERVADAS
BEGIN
dbms_output.put_line('>>>> Tabla RESERVADAS: Insertando valores...');
insert into RESERVADAS values ('ABS');
insert into RESERVADAS values ('ADD_MONTHS');
insert into RESERVADAS values ('ALL');
insert into RESERVADAS values ('AND');
insert into RESERVADAS values ('ASC');
insert into RESERVADAS values ('ASCII');
insert into RESERVADAS values ('AVG');
insert into RESERVADAS values ('BETWEEN');
insert into RESERVADAS values ('BY');
insert into RESERVADAS values ('CDEG');
insert into RESERVADAS values ('CEIL');
insert into RESERVADAS values ('CHARTOROWID');
insert into RESERVADAS values ('CHR');
insert into RESERVADAS values ('CONCAT');
insert into RESERVADAS values ('CONNECT');
insert into RESERVADAS values ('CONVERT');
insert into RESERVADAS values ('COS');
insert into RESERVADAS values ('COSH');
insert into RESERVADAS values ('COUNT');
insert into RESERVADAS values ('CURRVAL');
insert into RESERVADAS values ('DECODE');
insert into RESERVADAS values ('DESC');
insert into RESERVADAS values ('DISTINCT');
insert into RESERVADAS values ('DUMP');
insert into RESERVADAS values ('EXIT');
insert into RESERVADAS values ('EXP');
insert into RESERVADAS values ('FAVG');

insert into RESERVADAS values ('FEQ'); /* Comparadores difusos */
insert into RESERVADAS values ('FGT');
insert into RESERVADAS values ('FGEQ');
insert into RESERVADAS values ('FLT');
insert into RESERVADAS values ('FLEQ');
insert into RESERVADAS values ('MGT');
insert into RESERVADAS values ('MLT');
insert into RESERVADAS values ('NFEQ');
insert into RESERVADAS values ('NFGT');
insert into RESERVADAS values ('NFGEQ');
insert into RESERVADAS values ('NFLT');
insert into RESERVADAS values ('NFLEQ');
insert into RESERVADAS values ('NMGT');
insert into RESERVADAS values ('NMLT');

insert into RESERVADAS values ('LIKE');
insert into RESERVADAS values ('FLOOR');
insert into RESERVADAS values ('FMAX');
insert into RESERVADAS values ('FMIN');
insert into RESERVADAS values ('FROM');
insert into RESERVADAS values ('FSUM');
insert into RESERVADAS values ('GLB');
insert into RESERVADAS values ('GREATEST');
insert into RESERVADAS values ('GREATEST_LB');
insert into RESERVADAS values ('GROUP');
insert into RESERVADAS values ('HAVING');
insert into RESERVADAS values ('HEXTORAW');
insert into RESERVADAS values ('IN');
insert into RESERVADAS values ('INITCAP');
insert into RESERVADAS values ('INSTR');
insert into RESERVADAS values ('INSTRB');
insert into RESERVADAS values ('IS');
insert into RESERVADAS values ('LAST_DAY');
insert into RESERVADAS values ('LEAST');
insert into RESERVADAS values ('LEAST_UB');
insert into RESERVADAS values ('LENGTH');
insert into RESERVADAS values ('LENGTHB');
insert into RESERVADAS values ('LEVEL');
insert into RESERVADAS values ('LN');
insert into RESERVADAS values ('LOG');
insert into RESERVADAS values ('LOWER');
insert into RESERVADAS values ('LPAD');
insert into RESERVADAS values ('LTRIM');
insert into RESERVADAS values ('LUB');
insert into RESERVADAS values ('MAX');
insert into RESERVADAS values ('MIN');
insert into RESERVADAS values ('MOD');
insert into RESERVADAS values ('MONTHS_BETWEEN');
insert into RESERVADAS values ('NEW_TIME');
insert into RESERVADAS values ('NEXT_DAY');
insert into RESERVADAS values ('NEXTVAL');
insert into RESERVADAS values ('NLS_INITCAP');
insert into RESERVADAS values ('NLS_LOWER');
insert into RESERVADAS values ('NLS_UPPER');
insert into RESERVADAS values ('NLSSORT');
insert into RESERVADAS values ('NOT');
insert into RESERVADAS values ('NULL');
insert into RESERVADAS values ('NVL');
insert into RESERVADAS values ('OR');
insert into RESERVADAS values ('ORDER');
insert into RESERVADAS values ('POWER');
insert into RESERVADAS values ('PRIOR');
insert into RESERVADAS values ('RAWTOHEX');
insert into RESERVADAS values ('REPLACE');
insert into RESERVADAS values ('ROUND');
insert into RESERVADAS values ('ROWID');
insert into RESERVADAS values ('ROWIDTOCHAR');
insert into RESERVADAS values ('ROWNUM');
insert into RESERVADAS values ('RPAD');
insert into RESERVADAS values ('RTRIM');
insert into RESERVADAS values ('SELECT');
insert into RESERVADAS values ('SIGN');
insert into RESERVADAS values ('SIN');
insert into RESERVADAS values ('SINH');
insert into RESERVADAS values ('SOUNDEX');
insert into RESERVADAS values ('SQRT');
insert into RESERVADAS values ('START');
insert into RESERVADAS values ('STDDEV');
insert into RESERVADAS values ('SUBSTR');
insert into RESERVADAS values ('SUBSTRB');
insert into RESERVADAS values ('SUM');
insert into RESERVADAS values ('SYSDATE');
insert into RESERVADAS values ('TAN');
insert into RESERVADAS values ('TANH');
insert into RESERVADAS values ('THOLD');
insert into RESERVADAS values ('TO_CHAR');
insert into RESERVADAS values ('TO_DATE');
insert into RESERVADAS values ('TO_LABEL');
insert into RESERVADAS values ('TO_MULTI_BYTE');
insert into RESERVADAS values ('TO_NUMBER');
insert into RESERVADAS values ('TO_SINGLE_BYTE');
insert into RESERVADAS values ('TRASLATE');
insert into RESERVADAS values ('TRUNC');
insert into RESERVADAS values ('UID');
insert into RESERVADAS values ('UNDEFINED');
insert into RESERVADAS values ('UNKNOWN');
insert into RESERVADAS values ('UPPER');
insert into RESERVADAS values ('USER');
insert into RESERVADAS values ('USERENV');
insert into RESERVADAS values ('VARIANCE');
insert into RESERVADAS values ('VSIZE');
insert into RESERVADAS values ('WHERE');
insert into RESERVADAS values ('WITH');
insert into RESERVADAS values ('ADD');
insert into RESERVADAS values ('ALLOCATE');
insert into RESERVADAS values ('ALTER');
insert into RESERVADAS values ('ANY');
insert into RESERVADAS values ('AS');
insert into RESERVADAS values ('CASCADE');
insert into RESERVADAS values ('CLUSTER');
insert into RESERVADAS values ('CHECK');
insert into RESERVADAS values ('CONSTRAINT');
insert into RESERVADAS values ('CONSTRAINTS');
insert into RESERVADAS values ('CREATE');
insert into RESERVADAS values ('CRISP');
insert into RESERVADAS values ('DEFAULT');
insert into RESERVADAS values ('DELETE');
insert into RESERVADAS values ('DISABLE');
insert into RESERVADAS values ('DOMAIN');
insert into RESERVADAS values ('DROP');
insert into RESERVADAS values ('ENABLE');
insert into RESERVADAS values ('ESCAPE');
insert into RESERVADAS values ('EXCEPTIONS');
insert into RESERVADAS values ('EXISTS');
insert into RESERVADAS values ('EXTENT');
insert into RESERVADAS values ('FOREING');
insert into RESERVADAS values ('FREELIST');
insert into RESERVADAS values ('FREELISTS');
insert into RESERVADAS values ('GROUPS');
insert into RESERVADAS values ('INDEX');
insert into RESERVADAS values ('INITIAL');
insert into RESERVADAS values ('INSTANCE');
insert into RESERVADAS values ('INTO');
insert into RESERVADAS values ('INITRANS');
insert into RESERVADAS values ('K');
insert into RESERVADAS values ('KEY');
insert into RESERVADAS values ('LABEL');
insert into RESERVADAS values ('M');
insert into RESERVADAS values ('MAXTRANS');
insert into RESERVADAS values ('MINEXTENTS');
insert into RESERVADAS values ('MAXEXTENTS');
insert into RESERVADAS values ('NEARNESS');
insert into RESERVADAS values ('NEXT');
insert into RESERVADAS values ('ON');
insert into RESERVADAS values ('OPTIMAL');
insert into RESERVADAS values ('PCTFREE');
insert into RESERVADAS values ('PCTUSED');
insert into RESERVADAS values ('PCTINCREASE');
insert into RESERVADAS values ('POSIBILISTIC');
insert into RESERVADAS values ('PRIMARY');
insert into RESERVADAS values ('NULO');
insert into RESERVADAS values ('REFERENCES');
insert into RESERVADAS values ('ROWLABEL');
insert into RESERVADAS values ('SIZE');
insert into RESERVADAS values ('SOME');
insert into RESERVADAS values ('STORAGE');
insert into RESERVADAS values ('TABLE');
insert into RESERVADAS values ('TABLESPACE');
insert into RESERVADAS values ('TRIGGERS');
insert into RESERVADAS values ('UNIQUE');
insert into RESERVADAS values ('USING');
insert into RESERVADAS values ('VALUES');
insert into RESERVADAS values ('DATAFILE');
insert into RESERVADAS values ('MODIFY');
insert into RESERVADAS values ('SCALAR');
insert into RESERVADAS values ('NUMBER');
insert into RESERVADAS values ('DEC');
insert into RESERVADAS values ('DECIMAL');
insert into RESERVADAS values ('DOUBLE');
insert into RESERVADAS values ('PRECISION');
insert into RESERVADAS values ('FLOAT');
insert into RESERVADAS values ('INT');
insert into RESERVADAS values ('INTEGER');
insert into RESERVADAS values ('NUMERIC');
insert into RESERVADAS values ('REAL');
insert into RESERVADAS values ('SMALLINT');
insert into RESERVADAS values ('CHAR');
insert into RESERVADAS values ('CHARACTER');
insert into RESERVADAS values ('STRING');
insert into RESERVADAS values ('VARCHAR');
insert into RESERVADAS values ('VARCHAR2');
insert into RESERVADAS values ('LONG');
insert into RESERVADAS values ('RAW');
insert into RESERVADAS values ('LONGRAW');
insert into RESERVADAS values ('BOOLEAN');
insert into RESERVADAS values ('DATE');
insert into RESERVADAS values ('MLSLABEL');
insert into RESERVADAS values ('UNION');
insert into RESERVADAS values ('INTERSECT');
insert into RESERVADAS values ('MINUS');
COMMIT;
END;
/

-- TABLA de TRANSICIONES del AUTOMATA (para anlisis lxico)
DROP   TABLE T_TRANSI;
CREATE TABLE T_TRANSI (
  estado       NUMBER(2) NOT NULL, -- Estado actual
  caracter     NUMBER(3) NOT NULL, -- Carcter ledo
  sig_estado   NUMBER(2) NOT NULL, -- Estado siguiente a partir del actual y con ese carcter
  primary key (estado,caracter));

-- INSERCIONES en la tabla T_TRANSI
-- Es un procedimiento PL-SQL para aprovechar los bucles
DECLARE
  i INTEGER;
BEGIN
  dbms_output.put_line('>>>> Tabla T_TRANSI: Insertando de valores...');
  insert into T_TRANSI values(0 , ASCII('+'), 1  );
  insert into T_TRANSI values(0 , ASCII('-'), 2  );
  insert into T_TRANSI values(0 , ASCII('*'), 3  );
  insert into T_TRANSI values(0 , ASCII('/'), 4  );
  insert into T_TRANSI values(0 , ASCII('('), 5  );
  insert into T_TRANSI values(0 , ASCII(')'), 6  );
  insert into T_TRANSI values(0 , ASCII(','), 7  );
  insert into T_TRANSI values(0 , ASCII('.'), 8  );
  insert into T_TRANSI values(0 , ASCII('>'), 9  );
  insert into T_TRANSI values(0 , ASCII('$'), 10 );
  insert into T_TRANSI values(0 , ASCII('<'), 11 );
  insert into T_TRANSI values(0 , ASCII('='), 12 );
  insert into T_TRANSI values(13, ASCII('.'), 14 );
  insert into T_TRANSI values(9 , ASCII('='), 16 );
  insert into T_TRANSI values(11, ASCII('='), 17 );
  insert into T_TRANSI values(0 , ASCII('!'), 18 );
  insert into T_TRANSI values(0 , ASCII('^'), 18 );
  insert into T_TRANSI values(0 , ASCII(''), 18 );
  insert into T_TRANSI values(18, ASCII('='), 19 );
  insert into T_TRANSI values(11, ASCII('>'), 19 );
  insert into T_TRANSI values(0 , ASCII('['), 20 );
  insert into T_TRANSI values(0 , ASCII(']'), 21 );
  insert into T_TRANSI values(0 , ASCII(';'), 22 );
  insert into T_TRANSI values(0 , ASCII('#'), 27 );
  insert into T_TRANSI values(0 , ASCII('%'), 28 );
  insert into T_TRANSI values(0 , ASCII('{'), 29 );
  insert into T_TRANSI values(0 , ASCII('}'), 30 );
  insert into T_TRANSI values( 0,34,23); -- CADENAS ("...") y TEXTOS ('...')
  insert into T_TRANSI values(23,34,24); -- Del estado 25 y 23 a s mismos: En el anal. lxico
  insert into T_TRANSI values( 0,39,25);
  insert into T_TRANSI values(25,39,26);
--* Este bucle no se ejecuta porque para aceptar cualquier cosa en un
--* TEXTO o CADENA, se implementa en el A. lxico. As es + portable frente
--* a posibles cambios en el juego de caracteres de la mquina destino.
--*   FOR i IN 0..255 LOOP
--*       insert into T_TRANSI values(23,i,23); excepto i=34
--*       insert into T_TRANSI values(25,i,25); excepto i=39
--*   END LOOP;
  insert into T_TRANSI values(9 , ASCII(' '),  9);--Espacios entre !=, ^= y <>
  insert into T_TRANSI values(11, ASCII(' '), 11);
  insert into T_TRANSI values(18, ASCII(' '), 18);
  insert into T_TRANSI values( 9, 10,  9);
  insert into T_TRANSI values(11, 10, 11);
  insert into T_TRANSI values(18, 10, 18);
  insert into T_TRANSI values(9 , 13,  9);
  insert into T_TRANSI values(11, 13, 11);
  insert into T_TRANSI values(18, 13, 18);
  For i IN 65..90 LOOP
      insert into T_TRANSI values(0 , i, 15);
      insert into T_TRANSI values(15, i, 15);
  END LOOP;
  For i IN 97..122 LOOP
      insert into T_TRANSI values(0 , i, 15);
      insert into T_TRANSI values(15, i, 15);
  END LOOP;
  insert into T_TRANSI values(15, ASCII('$'), 15);
  insert into T_TRANSI values(15, ASCII('#'), 15);
  insert into T_TRANSI values(15, ASCII('_'), 15);
  For i IN 48..57 LOOP -- Nmeros
      insert into T_TRANSI values( 0, i, 13);
      insert into T_TRANSI values( 8, i, 14);
      insert into T_TRANSI values(13, i, 13);
      insert into T_TRANSI values(14, i, 14);
      insert into T_TRANSI values(15, i, 15);
      insert into T_TRANSI values(31, i, 33); -- Notacin cientfica o exponencial
      insert into T_TRANSI values(32, i, 33);
      insert into T_TRANSI values(33, i, 33);
  END LOOP;
  insert into T_TRANSI values(13,ascii('E'),31); -- Notacin cientfica
  insert into T_TRANSI values(14,ascii('E'),31);
  insert into T_TRANSI values(31,ascii('+'),32);
  insert into T_TRANSI values(31,ascii('-'),32);
  insert into T_TRANSI values( 0,ascii('|'),35); -- Operador ||
  insert into T_TRANSI values(35,ascii(' '),35);
  insert into T_TRANSI values(35,ascii('|'),36);

  insert into T_TRANSI values(2,ascii('-'),37); -- Comentarios con '--'
  insert into T_TRANSI values(37,13,38);        -- terminan con el carcter 13  el 10
  insert into T_TRANSI values(37,10,38);
  insert into T_TRANSI values(4,ascii('*'),39);  -- Comentarios con '/*'
  insert into T_TRANSI values(39,ascii('*'),40); -- terminan con '*/'
  insert into T_TRANSI values(40,ascii('*'),40);
  insert into T_TRANSI values(40,ascii('/'),38);
  COMMIT;
END;
/

/*****************************************/
/***  TABLAS del  ANALISIS SINTACTICO  ***/
/*****************************************/

-- TABLA de PRODUCCIONES
DROP   TABLE PRODUCCIONES;
CREATE TABLE PRODUCCIONES (
  num_prod  NUMBER(9) NOT NULL,
  posicion  NUMBER(2) NOT NULL,
  parte_der VARCHAR2(20),
  terminal_der CHAR   NOT NULL,
  PRIMARY KEY (num_prod,posicion));
-- CAMPOS:
-- parte_izq    Smbolo NO terminal de la izquierda de una produccin
-- posicion Posicin que ocupa 'parte_der' en esa produccin (entero positivo)
-- parte_der    Smbolo NT  T de la derecha que esta en esa 'posicion'
-- terminal_der Indica si 'parte_der' es Terminal ('T') o NT ('N')

--*********  TABLA de TRANSICIONES del ANALIZADOR SINTCTICO  *********
--*********  segn la gramtica LL(1) usada.                  *********
DROP   TABLE TABLA_SINTAX;
CREATE TABLE TABLA_SINTAX (
  simbolo_NT VARCHAR2(20) NOT NULL, --PRODUCCIONES.parte_der%TYPE
  simbolo_T  VARCHAR2(20) NOT NULL,
  num_prod   NUMBER(3)    NOT NULL, --PRODUCCIONES.num_prod%TYPE
  PRIMARY KEY (simbolo_NT,simbolo_T));
-- CAMPOS:
-- simbolo_NT   Smbolo No Terminal encontrado en la pila
-- simbolo_T    Smbolo Terminal (token) leido de la consulta de entrada
-- num_prod     Nmero de produccin a aplicar en este caso

--********* INSERCIN EN TABLA PRODUCCIONES Y TABLA_SINTAX *********
-- Las producciones estn numeradas empezando por la 1 (no la 0).
-- Cada 'grupo' de producciones se comienza numerando en un mltiplo de 10
-- (as quedan nmeros libres por si se amplia/modifica la gramtica).
-- Convenio: En maysculas los Smbolos T y en minsculas los NT.
-- Para cada produccin:  A --> B C...
--   1. Insertar en PRODUCCIONES una tupla por cada smbolo en B C...,
--      numerados por orden por el segundo campo (posicion).
--      En el ltimo campo, indicar si es o no smbolo terminal.
--      Si es la cadena vaca: Insertar 'VACIO' (como smbolo NT).
--   2. Insertar en TABLA_SINTAX tuplas con A en el primer campo.
--      El tercer campo el nmero de esa produccin.
--      El segundo campo tendr un smbolo Terminal por cada tupla.
--      Este smbolo estar entre los siguientes (Smbolos Directores):
--         Si B C... no es anulable:   Iniciales(B C...)
--         Si B C... s es anulable:   Iniciales(B C...) U Seguidores(A)

-- Dividido en bloques para que no de problemas de memoria (ORA-04031)
DECLARE -- Bloque 1
  FIN CONSTANT PRODUCCIONES.parte_der%TYPE := 'THE END';
BEGIN
dbms_output.put_line('>>>> Tablas PRODUCCIONES y TABLA_SINTAX: Insertando valores... Bloque 1/3');

--1: consulta:  select_command fin_consulta
INSERT INTO PRODUCCIONES VALUES (1,1,'select_command','N');
INSERT INTO PRODUCCIONES VALUES (1,2,'fin_consulta','N');
INSERT INTO TABLA_SINTAX VALUES ('consulta','(',1);
INSERT INTO TABLA_SINTAX VALUES ('consulta','SELECT',1);

--2: fin_consulta:  ';'
INSERT INTO PRODUCCIONES VALUES (2,1,';','T');
INSERT INTO TABLA_SINTAX VALUES ('fin_consulta',';',2);
--3:        |
INSERT INTO PRODUCCIONES VALUES (3,1,'VACIO','N');
INSERT INTO TABLA_SINTAX VALUES ('fin_consulta',FIN,3);

--4: select_command:    select_element resto_select clausula_orden
INSERT INTO PRODUCCIONES VALUES (4,1,'select_element','N');
INSERT INTO PRODUCCIONES VALUES (4,2,'resto_select','N');
INSERT INTO PRODUCCIONES VALUES (4,3,'clausula_orden','N');
INSERT INTO TABLA_SINTAX VALUES ('select_command','(',4);
INSERT INTO TABLA_SINTAX VALUES ('select_command','SELECT',4);

--5: select_element:    '(' select_command ')'
INSERT INTO PRODUCCIONES VALUES (5,1,'(','T');
INSERT INTO PRODUCCIONES VALUES (5,2,'select_command','N');
INSERT INTO PRODUCCIONES VALUES (5,3,')','T');
INSERT INTO TABLA_SINTAX VALUES ('select_element','(',5);
--6:    |   SELECT select_list FROM tablas  clausula_where clausula_variante
INSERT INTO PRODUCCIONES VALUES (6,1,'SELECT','T');
INSERT INTO PRODUCCIONES VALUES (6,2,'select_list','N');
INSERT INTO PRODUCCIONES VALUES (6,3,'FROM','T');
INSERT INTO PRODUCCIONES VALUES (6,4,'tablas','N');
INSERT INTO PRODUCCIONES VALUES (6,5,'clausula_where','N');
INSERT INTO PRODUCCIONES VALUES (6,6,'clausula_variante','N');
INSERT INTO TABLA_SINTAX VALUES ('select_element','SELECT',6);

/*****> Definicin de las operaciones de conjuntos <*****/
--10: resto_select: set_command resto_select
INSERT INTO PRODUCCIONES VALUES (10,1,'set_command','N');
INSERT INTO PRODUCCIONES VALUES (10,2,'resto_select','N');
INSERT INTO TABLA_SINTAX VALUES ('resto_select','UNION',10);
INSERT INTO TABLA_SINTAX VALUES ('resto_select','INTERSECT',10);
INSERT INTO TABLA_SINTAX VALUES ('resto_select','MINUS',10);
--11:       |
INSERT INTO PRODUCCIONES VALUES (11,1,'VACIO','N');
INSERT INTO TABLA_SINTAX VALUES ('resto_select',';',11);
INSERT INTO TABLA_SINTAX VALUES ('resto_select',FIN,11);
INSERT INTO TABLA_SINTAX VALUES ('resto_select','ORDER',11);
INSERT INTO TABLA_SINTAX VALUES ('resto_select',')',11);

--12: set_command:UNION all_ono select_element
INSERT INTO PRODUCCIONES VALUES (12,1,'UNION','T');
INSERT INTO PRODUCCIONES VALUES (12,2,'all_ono','N');
INSERT INTO PRODUCCIONES VALUES (12,3,'select_element','N');
INSERT INTO TABLA_SINTAX VALUES ('set_command','UNION',12);
--13:       |   INTERSECT     select_element
INSERT INTO PRODUCCIONES VALUES (13,1,'INTERSECT','T');
INSERT INTO PRODUCCIONES VALUES (13,2,'select_element','N');
INSERT INTO TABLA_SINTAX VALUES ('set_command','INTERSECT',13);
--14:       |   MINUS         select_element
INSERT INTO PRODUCCIONES VALUES (14,1,'MINUS','T');
INSERT INTO PRODUCCIONES VALUES (14,2,'select_element','N');
INSERT INTO TABLA_SINTAX VALUES ('set_command','MINUS',14);

--15: all_ono:  ALL
INSERT INTO PRODUCCIONES VALUES (15,1,'ALL','T');
INSERT INTO TABLA_SINTAX VALUES ('all_ono','ALL',15);
--16:       |
INSERT INTO PRODUCCIONES VALUES (16,1,'VACIO','N');
INSERT INTO TABLA_SINTAX VALUES ('all_ono','(',16);
INSERT INTO TABLA_SINTAX VALUES ('all_ono','SELECT',16);

/*****> (datos justo despus de la palabra SELECT)  <*****/
--17: select_list   :   lista_datos
INSERT INTO PRODUCCIONES VALUES (17,1,'lista_datos','N');
-- Iniciales(lista_datos)
INSERT INTO TABLA_SINTAX VALUES ('select_list','*',17);
INSERT INTO TABLA_SINTAX VALUES ('select_list','%',17);
INSERT INTO TABLA_SINTAX VALUES ('select_list','+',17);
INSERT INTO TABLA_SINTAX VALUES ('select_list','-',17);
INSERT INTO TABLA_SINTAX VALUES ('select_list','PRIOR',17);
INSERT INTO TABLA_SINTAX VALUES ('select_list','(',17);
INSERT INTO TABLA_SINTAX VALUES ('select_list','{',17);
/* ctes */
INSERT INTO TABLA_SINTAX VALUES ('select_list','NUMERO',17);
INSERT INTO TABLA_SINTAX VALUES ('select_list','SYSDATE',17);
INSERT INTO TABLA_SINTAX VALUES ('select_list','UID',17);
INSERT INTO TABLA_SINTAX VALUES ('select_list','USER',17);
INSERT INTO TABLA_SINTAX VALUES ('select_list','TEXTO',17);
INSERT INTO TABLA_SINTAX VALUES ('select_list','LEVEL',17);
INSERT INTO TABLA_SINTAX VALUES ('select_list','NULL',17);
INSERT INTO TABLA_SINTAX VALUES ('select_list','UNDEFINED',17);
INSERT INTO TABLA_SINTAX VALUES ('select_list','UNKNOWN',17);
/* columna */
INSERT INTO TABLA_SINTAX VALUES ('select_list','ID',17);
INSERT INTO TABLA_SINTAX VALUES ('select_list','ROWID',17);
INSERT INTO TABLA_SINTAX VALUES ('select_list','ROWNUM',17);
/* funciones */
INSERT INTO TABLA_SINTAX VALUES ('select_list','ABS',17);
INSERT INTO TABLA_SINTAX VALUES ('select_list','CDEG',17);
INSERT INTO TABLA_SINTAX VALUES ('select_list','CEIL',17);
INSERT INTO TABLA_SINTAX VALUES ('select_list','FLOOR',17);
INSERT INTO TABLA_SINTAX VALUES ('select_list','SIGN',17);
INSERT INTO TABLA_SINTAX VALUES ('select_list','SQRT',17);
INSERT INTO TABLA_SINTAX VALUES ('select_list','CHR',17);
INSERT INTO TABLA_SINTAX VALUES ('select_list','MOD',17);
INSERT INTO TABLA_SINTAX VALUES ('select_list','POWER',17);
INSERT INTO TABLA_SINTAX VALUES ('select_list','INITCAP',17);
INSERT INTO TABLA_SINTAX VALUES ('select_list','LOWER',17);
INSERT INTO TABLA_SINTAX VALUES ('select_list','LPAD',17);
INSERT INTO TABLA_SINTAX VALUES ('select_list','LTRIM',17);
INSERT INTO TABLA_SINTAX VALUES ('select_list','REPLACE',17);
INSERT INTO TABLA_SINTAX VALUES ('select_list','RPAD',17);
INSERT INTO TABLA_SINTAX VALUES ('select_list','RTRIM',17);
INSERT INTO TABLA_SINTAX VALUES ('select_list','SOUNDEX',17);
INSERT INTO TABLA_SINTAX VALUES ('select_list','SUBSTR',17);
INSERT INTO TABLA_SINTAX VALUES ('select_list','TRANSLATE',17);
INSERT INTO TABLA_SINTAX VALUES ('select_list','UPPER',17);
INSERT INTO TABLA_SINTAX VALUES ('select_list','ASCII',17);
INSERT INTO TABLA_SINTAX VALUES ('select_list','INSTR',17);
INSERT INTO TABLA_SINTAX VALUES ('select_list','LENGTH',17);
INSERT INTO TABLA_SINTAX VALUES ('select_list','NLSSORT',17);
INSERT INTO TABLA_SINTAX VALUES ('select_list','AVG',17);
INSERT INTO TABLA_SINTAX VALUES ('select_list','COUNT',17);
INSERT INTO TABLA_SINTAX VALUES ('select_list','MAX',17);
INSERT INTO TABLA_SINTAX VALUES ('select_list','MIN',17);
INSERT INTO TABLA_SINTAX VALUES ('select_list','STDDEV',17);
INSERT INTO TABLA_SINTAX VALUES ('select_list','SUM',17);
INSERT INTO TABLA_SINTAX VALUES ('select_list','VARIANCE',17);
INSERT INTO TABLA_SINTAX VALUES ('select_list','CHARTOROWID',17);
INSERT INTO TABLA_SINTAX VALUES ('select_list','CONVERT',17);
INSERT INTO TABLA_SINTAX VALUES ('select_list','HEXTORAW',17);
INSERT INTO TABLA_SINTAX VALUES ('select_list','RAWTOHEX',17);
INSERT INTO TABLA_SINTAX VALUES ('select_list','ROWIDTOCHAR',17);
INSERT INTO TABLA_SINTAX VALUES ('select_list','TO_CHAR',17);
INSERT INTO TABLA_SINTAX VALUES ('select_list','TO_DATE',17);
INSERT INTO TABLA_SINTAX VALUES ('select_list','TO_NUMBER',17);
INSERT INTO TABLA_SINTAX VALUES ('select_list','ADD_MONTHS',17);
INSERT INTO TABLA_SINTAX VALUES ('select_list','LAST_DAY',17);
INSERT INTO TABLA_SINTAX VALUES ('select_list','MONTHS_BETWEEN',17);
INSERT INTO TABLA_SINTAX VALUES ('select_list','NEW_TIME',17);
INSERT INTO TABLA_SINTAX VALUES ('select_list','NEXT_DAY',17);
INSERT INTO TABLA_SINTAX VALUES ('select_list','ROUND',17);
INSERT INTO TABLA_SINTAX VALUES ('select_list','TRUNC',17);
INSERT INTO TABLA_SINTAX VALUES ('select_list','DUMP',17);
INSERT INTO TABLA_SINTAX VALUES ('select_list','GREATEST',17);
INSERT INTO TABLA_SINTAX VALUES ('select_list','LEAST',17);
INSERT INTO TABLA_SINTAX VALUES ('select_list','NVL',17);
INSERT INTO TABLA_SINTAX VALUES ('select_list','USERENV',17);
INSERT INTO TABLA_SINTAX VALUES ('select_list','VSIZE',17);
INSERT INTO TABLA_SINTAX VALUES ('select_list','DECODE',17);
--18:       |   ALL lista_datos
INSERT INTO PRODUCCIONES VALUES (18,1,'ALL','T');
INSERT INTO PRODUCCIONES VALUES (18,2,'lista_datos','N');
INSERT INTO TABLA_SINTAX VALUES ('select_list','ALL',18);
--19:       |   DISTINCT lista_datos
INSERT INTO PRODUCCIONES VALUES (19,1,'DISTINCT','T');
INSERT INTO PRODUCCIONES VALUES (19,2,'lista_datos','N');
INSERT INTO TABLA_SINTAX VALUES ('select_list','DISTINCT',19);

--20: lista_datos   :   '*'
INSERT INTO PRODUCCIONES VALUES (20,1,'*','T');
INSERT INTO TABLA_SINTAX VALUES ('lista_datos','*',20);
--21:       |   '%'
INSERT INTO PRODUCCIONES VALUES (21,1,'%','T');
INSERT INTO TABLA_SINTAX VALUES ('lista_datos','%',21);
--22:       |   expr c_alias mas_datos
INSERT INTO PRODUCCIONES VALUES (22,1,'expr','N');
INSERT INTO PRODUCCIONES VALUES (22,2,'c_alias','N');
INSERT INTO PRODUCCIONES VALUES (22,3,'mas_datos','N');
--Iniciales(expr)
INSERT INTO TABLA_SINTAX VALUES ('lista_datos','+',22);
INSERT INTO TABLA_SINTAX VALUES ('lista_datos','-',22);
INSERT INTO TABLA_SINTAX VALUES ('lista_datos','PRIOR',22);
INSERT INTO TABLA_SINTAX VALUES ('lista_datos','(',22);
INSERT INTO TABLA_SINTAX VALUES ('lista_datos','{',22);
/* ctes */
INSERT INTO TABLA_SINTAX VALUES ('lista_datos','NUMERO',22);
INSERT INTO TABLA_SINTAX VALUES ('lista_datos','SYSDATE',22);
INSERT INTO TABLA_SINTAX VALUES ('lista_datos','UID',22);
INSERT INTO TABLA_SINTAX VALUES ('lista_datos','USER',22);
INSERT INTO TABLA_SINTAX VALUES ('lista_datos','TEXTO',22);
INSERT INTO TABLA_SINTAX VALUES ('lista_datos','LEVEL',22);
INSERT INTO TABLA_SINTAX VALUES ('lista_datos','NULL',22);
INSERT INTO TABLA_SINTAX VALUES ('lista_datos','UNDEFINED',22);
INSERT INTO TABLA_SINTAX VALUES ('lista_datos','UNKNOWN',22);
/* columna */
INSERT INTO TABLA_SINTAX VALUES ('lista_datos','ID',22);
INSERT INTO TABLA_SINTAX VALUES ('lista_datos','ROWID',22);
INSERT INTO TABLA_SINTAX VALUES ('lista_datos','ROWNUM',22);
/* funciones */
INSERT INTO TABLA_SINTAX VALUES ('lista_datos','ABS',22);
INSERT INTO TABLA_SINTAX VALUES ('lista_datos','CDEG',22);
INSERT INTO TABLA_SINTAX VALUES ('lista_datos','CEIL',22);
INSERT INTO TABLA_SINTAX VALUES ('lista_datos','FLOOR',22);
INSERT INTO TABLA_SINTAX VALUES ('lista_datos','SIGN',22);
INSERT INTO TABLA_SINTAX VALUES ('lista_datos','SQRT',22);
INSERT INTO TABLA_SINTAX VALUES ('lista_datos','CHR',22);
INSERT INTO TABLA_SINTAX VALUES ('lista_datos','MOD',22);
INSERT INTO TABLA_SINTAX VALUES ('lista_datos','POWER',22);
INSERT INTO TABLA_SINTAX VALUES ('lista_datos','INITCAP',22);
INSERT INTO TABLA_SINTAX VALUES ('lista_datos','LOWER',22);
INSERT INTO TABLA_SINTAX VALUES ('lista_datos','LPAD',22);
INSERT INTO TABLA_SINTAX VALUES ('lista_datos','LTRIM',22);
INSERT INTO TABLA_SINTAX VALUES ('lista_datos','REPLACE',22);
INSERT INTO TABLA_SINTAX VALUES ('lista_datos','RPAD',22);
INSERT INTO TABLA_SINTAX VALUES ('lista_datos','RTRIM',22);
INSERT INTO TABLA_SINTAX VALUES ('lista_datos','SOUNDEX',22);
INSERT INTO TABLA_SINTAX VALUES ('lista_datos','SUBSTR',22);
INSERT INTO TABLA_SINTAX VALUES ('lista_datos','TRANSLATE',22);
INSERT INTO TABLA_SINTAX VALUES ('lista_datos','UPPER',22);
INSERT INTO TABLA_SINTAX VALUES ('lista_datos','ASCII',22);
INSERT INTO TABLA_SINTAX VALUES ('lista_datos','INSTR',22);
INSERT INTO TABLA_SINTAX VALUES ('lista_datos','LENGTH',22);
INSERT INTO TABLA_SINTAX VALUES ('lista_datos','NLSSORT',22);
INSERT INTO TABLA_SINTAX VALUES ('lista_datos','AVG',22);
INSERT INTO TABLA_SINTAX VALUES ('lista_datos','COUNT',22);
INSERT INTO TABLA_SINTAX VALUES ('lista_datos','MAX',22);
INSERT INTO TABLA_SINTAX VALUES ('lista_datos','MIN',22);
INSERT INTO TABLA_SINTAX VALUES ('lista_datos','STDDEV',22);
INSERT INTO TABLA_SINTAX VALUES ('lista_datos','SUM',22);
INSERT INTO TABLA_SINTAX VALUES ('lista_datos','VARIANCE',22);
INSERT INTO TABLA_SINTAX VALUES ('lista_datos','CHARTOROWID',22);
INSERT INTO TABLA_SINTAX VALUES ('lista_datos','CONVERT',22);
INSERT INTO TABLA_SINTAX VALUES ('lista_datos','HEXTORAW',22);
INSERT INTO TABLA_SINTAX VALUES ('lista_datos','RAWTOHEX',22);
INSERT INTO TABLA_SINTAX VALUES ('lista_datos','ROWIDTOCHAR',22);
INSERT INTO TABLA_SINTAX VALUES ('lista_datos','TO_CHAR',22);
INSERT INTO TABLA_SINTAX VALUES ('lista_datos','TO_DATE',22);
INSERT INTO TABLA_SINTAX VALUES ('lista_datos','TO_NUMBER',22);
INSERT INTO TABLA_SINTAX VALUES ('lista_datos','ADD_MONTHS',22);
INSERT INTO TABLA_SINTAX VALUES ('lista_datos','LAST_DAY',22);
INSERT INTO TABLA_SINTAX VALUES ('lista_datos','MONTHS_BETWEEN',22);
INSERT INTO TABLA_SINTAX VALUES ('lista_datos','NEW_TIME',22);
INSERT INTO TABLA_SINTAX VALUES ('lista_datos','NEXT_DAY',22);
INSERT INTO TABLA_SINTAX VALUES ('lista_datos','ROUND',22);
INSERT INTO TABLA_SINTAX VALUES ('lista_datos','TRUNC',22);
INSERT INTO TABLA_SINTAX VALUES ('lista_datos','DUMP',22);
INSERT INTO TABLA_SINTAX VALUES ('lista_datos','GREATEST',22);
INSERT INTO TABLA_SINTAX VALUES ('lista_datos','LEAST',22);
INSERT INTO TABLA_SINTAX VALUES ('lista_datos','NVL',22);
INSERT INTO TABLA_SINTAX VALUES ('lista_datos','USERENV',22);
INSERT INTO TABLA_SINTAX VALUES ('lista_datos','VSIZE',22);
INSERT INTO TABLA_SINTAX VALUES ('lista_datos','DECODE',22);

--23: mas_datos:    ',' expr c_alias mas_datos
INSERT INTO PRODUCCIONES VALUES (23,1,',','T');
INSERT INTO PRODUCCIONES VALUES (23,2,'expr','N');
INSERT INTO PRODUCCIONES VALUES (23,3,'c_alias','N');
INSERT INTO PRODUCCIONES VALUES (23,4,'mas_datos','N');
INSERT INTO TABLA_SINTAX VALUES ('mas_datos',',',23);
--24:       |
INSERT INTO PRODUCCIONES VALUES (24,1,'VACIO','N');
INSERT INTO TABLA_SINTAX VALUES ('mas_datos','FROM',24);

--25: c_alias:  cadid
INSERT INTO PRODUCCIONES VALUES (25,1,'cadid','N');
INSERT INTO TABLA_SINTAX VALUES ('c_alias','CADENA',25);
INSERT INTO TABLA_SINTAX VALUES ('c_alias','ID',25);
--26:       |   AS cadid
INSERT INTO PRODUCCIONES VALUES (26,1,'AS','T');
INSERT INTO PRODUCCIONES VALUES (26,2,'cadid','N');
INSERT INTO TABLA_SINTAX VALUES ('c_alias','AS',26);
--27:       |
INSERT INTO PRODUCCIONES VALUES (27,1,'VACIO','N');
INSERT INTO TABLA_SINTAX VALUES ('c_alias',',',27);
INSERT INTO TABLA_SINTAX VALUES ('c_alias','FROM',27);

--28/29: cadid: CADENA | ID
INSERT INTO PRODUCCIONES VALUES (28,1,'CADENA','T');
INSERT INTO PRODUCCIONES VALUES (29,1,'ID','T');
INSERT INTO TABLA_SINTAX VALUES ('cadid','CADENA',28);
INSERT INTO TABLA_SINTAX VALUES ('cadid','ID',29);

-- Expresiones: expr
--30: expr  :   expr_maxprior resto_expr
INSERT INTO PRODUCCIONES VALUES (30,1,'expr_maxprior','N');
INSERT INTO PRODUCCIONES VALUES (30,2,'resto_expr','N');
-- Insertamos en TABLA_SINTAX: Iniciales(expr_maxprior)=Iniciales(expr)
INSERT INTO TABLA_SINTAX VALUES ('expr','+',30);
INSERT INTO TABLA_SINTAX VALUES ('expr','-',30);
INSERT INTO TABLA_SINTAX VALUES ('expr','PRIOR',30);
INSERT INTO TABLA_SINTAX VALUES ('expr','(',30);
INSERT INTO TABLA_SINTAX VALUES ('expr','{',30);
/* ctes */
INSERT INTO TABLA_SINTAX VALUES ('expr','NUMERO',30);
INSERT INTO TABLA_SINTAX VALUES ('expr','SYSDATE',30);
INSERT INTO TABLA_SINTAX VALUES ('expr','UID',30);
INSERT INTO TABLA_SINTAX VALUES ('expr','USER',30);
INSERT INTO TABLA_SINTAX VALUES ('expr','TEXTO',30);
INSERT INTO TABLA_SINTAX VALUES ('expr','LEVEL',30);
INSERT INTO TABLA_SINTAX VALUES ('expr','NULL',30);
INSERT INTO TABLA_SINTAX VALUES ('expr','UNDEFINED',30);
INSERT INTO TABLA_SINTAX VALUES ('expr','UNKNOWN',30);
/* columna */
INSERT INTO TABLA_SINTAX VALUES ('expr','ID',30);
INSERT INTO TABLA_SINTAX VALUES ('expr','ROWID',30);
INSERT INTO TABLA_SINTAX VALUES ('expr','ROWNUM',30);
/* funciones */
INSERT INTO TABLA_SINTAX VALUES ('expr','ABS',30);
INSERT INTO TABLA_SINTAX VALUES ('expr','CDEG',30);
INSERT INTO TABLA_SINTAX VALUES ('expr','CEIL',30);
INSERT INTO TABLA_SINTAX VALUES ('expr','FLOOR',30);
INSERT INTO TABLA_SINTAX VALUES ('expr','SIGN',30);
INSERT INTO TABLA_SINTAX VALUES ('expr','SQRT',30);
INSERT INTO TABLA_SINTAX VALUES ('expr','CHR',30);
INSERT INTO TABLA_SINTAX VALUES ('expr','MOD',30);
INSERT INTO TABLA_SINTAX VALUES ('expr','POWER',30);
INSERT INTO TABLA_SINTAX VALUES ('expr','INITCAP',30);
INSERT INTO TABLA_SINTAX VALUES ('expr','LOWER',30);
INSERT INTO TABLA_SINTAX VALUES ('expr','LPAD',30);
INSERT INTO TABLA_SINTAX VALUES ('expr','LTRIM',30);
INSERT INTO TABLA_SINTAX VALUES ('expr','REPLACE',30);
INSERT INTO TABLA_SINTAX VALUES ('expr','RPAD',30);
INSERT INTO TABLA_SINTAX VALUES ('expr','RTRIM',30);
INSERT INTO TABLA_SINTAX VALUES ('expr','SOUNDEX',30);
INSERT INTO TABLA_SINTAX VALUES ('expr','SUBSTR',30);
INSERT INTO TABLA_SINTAX VALUES ('expr','TRANSLATE',30);
INSERT INTO TABLA_SINTAX VALUES ('expr','UPPER',30);
INSERT INTO TABLA_SINTAX VALUES ('expr','ASCII',30);
INSERT INTO TABLA_SINTAX VALUES ('expr','INSTR',30);
INSERT INTO TABLA_SINTAX VALUES ('expr','LENGTH',30);
INSERT INTO TABLA_SINTAX VALUES ('expr','NLSSORT',30);
INSERT INTO TABLA_SINTAX VALUES ('expr','AVG',30);
INSERT INTO TABLA_SINTAX VALUES ('expr','COUNT',30);
INSERT INTO TABLA_SINTAX VALUES ('expr','MAX',30);
INSERT INTO TABLA_SINTAX VALUES ('expr','MIN',30);
INSERT INTO TABLA_SINTAX VALUES ('expr','STDDEV',30);
INSERT INTO TABLA_SINTAX VALUES ('expr','SUM',30);
INSERT INTO TABLA_SINTAX VALUES ('expr','VARIANCE',30);
INSERT INTO TABLA_SINTAX VALUES ('expr','CHARTOROWID',30);
INSERT INTO TABLA_SINTAX VALUES ('expr','CONVERT',30);
INSERT INTO TABLA_SINTAX VALUES ('expr','HEXTORAW',30);
INSERT INTO TABLA_SINTAX VALUES ('expr','RAWTOHEX',30);
INSERT INTO TABLA_SINTAX VALUES ('expr','ROWIDTOCHAR',30);
INSERT INTO TABLA_SINTAX VALUES ('expr','TO_CHAR',30);
INSERT INTO TABLA_SINTAX VALUES ('expr','TO_DATE',30);
INSERT INTO TABLA_SINTAX VALUES ('expr','TO_NUMBER',30);
INSERT INTO TABLA_SINTAX VALUES ('expr','ADD_MONTHS',30);
INSERT INTO TABLA_SINTAX VALUES ('expr','LAST_DAY',30);
INSERT INTO TABLA_SINTAX VALUES ('expr','MONTHS_BETWEEN',30);
INSERT INTO TABLA_SINTAX VALUES ('expr','NEW_TIME',30);
INSERT INTO TABLA_SINTAX VALUES ('expr','NEXT_DAY',30);
INSERT INTO TABLA_SINTAX VALUES ('expr','ROUND',30);
INSERT INTO TABLA_SINTAX VALUES ('expr','TRUNC',30);
INSERT INTO TABLA_SINTAX VALUES ('expr','DUMP',30);
INSERT INTO TABLA_SINTAX VALUES ('expr','GREATEST',30);
INSERT INTO TABLA_SINTAX VALUES ('expr','LEAST',30);
INSERT INTO TABLA_SINTAX VALUES ('expr','NVL',30);
INSERT INTO TABLA_SINTAX VALUES ('expr','USERENV',30);
INSERT INTO TABLA_SINTAX VALUES ('expr','VSIZE',30);
INSERT INTO TABLA_SINTAX VALUES ('expr','DECODE',30);

--31: expr_element  :   '(' condition ')'
INSERT INTO PRODUCCIONES VALUES (31,1,'(','T');
INSERT INTO PRODUCCIONES VALUES (31,2,'condition','N');
INSERT INTO PRODUCCIONES VALUES (31,3,')','T');
INSERT INTO TABLA_SINTAX VALUES ('expr_element','(',31);
--32        |   '{' condition '}'
INSERT INTO PRODUCCIONES VALUES (32,1,'{','T');
INSERT INTO PRODUCCIONES VALUES (32,2,'condition','N');
INSERT INTO PRODUCCIONES VALUES (32,3,'}','T');
INSERT INTO TABLA_SINTAX VALUES ('expr_element','{',32);
--33        |   ctes
INSERT INTO PRODUCCIONES VALUES (33,1,'ctes','N');
INSERT INTO TABLA_SINTAX VALUES ('expr_element','NUMERO',33);
INSERT INTO TABLA_SINTAX VALUES ('expr_element','SYSDATE',33);
INSERT INTO TABLA_SINTAX VALUES ('expr_element','UID',33);
INSERT INTO TABLA_SINTAX VALUES ('expr_element','USER',33);
INSERT INTO TABLA_SINTAX VALUES ('expr_element','TEXTO',33);
INSERT INTO TABLA_SINTAX VALUES ('expr_element','LEVEL',33);
INSERT INTO TABLA_SINTAX VALUES ('expr_element','NULL',33);
INSERT INTO TABLA_SINTAX VALUES ('expr_element','UNDEFINED',33);
INSERT INTO TABLA_SINTAX VALUES ('expr_element','UNKNOWN',33);
--34        |   columna
INSERT INTO PRODUCCIONES VALUES (34,1,'columna','N');
INSERT INTO TABLA_SINTAX VALUES ('expr_element','ID',34);
INSERT INTO TABLA_SINTAX VALUES ('expr_element','ROWID',34);
INSERT INTO TABLA_SINTAX VALUES ('expr_element','ROWNUM',34);
--35        |   funcion
INSERT INTO PRODUCCIONES VALUES (35,1,'funcion','N');
INSERT INTO TABLA_SINTAX VALUES ('expr_element','ABS',35);
INSERT INTO TABLA_SINTAX VALUES ('expr_element','CDEG',35);
INSERT INTO TABLA_SINTAX VALUES ('expr_element','CEIL',35);
INSERT INTO TABLA_SINTAX VALUES ('expr_element','FLOOR',35);
INSERT INTO TABLA_SINTAX VALUES ('expr_element','SIGN',35);
INSERT INTO TABLA_SINTAX VALUES ('expr_element','SQRT',35);
INSERT INTO TABLA_SINTAX VALUES ('expr_element','CHR',35);
INSERT INTO TABLA_SINTAX VALUES ('expr_element','MOD',35);
INSERT INTO TABLA_SINTAX VALUES ('expr_element','POWER',35);
INSERT INTO TABLA_SINTAX VALUES ('expr_element','INITCAP',35);
INSERT INTO TABLA_SINTAX VALUES ('expr_element','LOWER',35);
INSERT INTO TABLA_SINTAX VALUES ('expr_element','LPAD',35);
INSERT INTO TABLA_SINTAX VALUES ('expr_element','LTRIM',35);
INSERT INTO TABLA_SINTAX VALUES ('expr_element','REPLACE',35);
INSERT INTO TABLA_SINTAX VALUES ('expr_element','RPAD',35);
INSERT INTO TABLA_SINTAX VALUES ('expr_element','RTRIM',35);
INSERT INTO TABLA_SINTAX VALUES ('expr_element','SOUNDEX',35);
INSERT INTO TABLA_SINTAX VALUES ('expr_element','SUBSTR',35);
INSERT INTO TABLA_SINTAX VALUES ('expr_element','TRANSLATE',35);
INSERT INTO TABLA_SINTAX VALUES ('expr_element','UPPER',35);
INSERT INTO TABLA_SINTAX VALUES ('expr_element','ASCII',35);
INSERT INTO TABLA_SINTAX VALUES ('expr_element','INSTR',35);
INSERT INTO TABLA_SINTAX VALUES ('expr_element','LENGTH',35);
INSERT INTO TABLA_SINTAX VALUES ('expr_element','NLSSORT',35);
INSERT INTO TABLA_SINTAX VALUES ('expr_element','AVG',35);
INSERT INTO TABLA_SINTAX VALUES ('expr_element','COUNT',35);
INSERT INTO TABLA_SINTAX VALUES ('expr_element','MAX',35);
INSERT INTO TABLA_SINTAX VALUES ('expr_element','MIN',35);
INSERT INTO TABLA_SINTAX VALUES ('expr_element','STDDEV',35);
INSERT INTO TABLA_SINTAX VALUES ('expr_element','SUM',35);
INSERT INTO TABLA_SINTAX VALUES ('expr_element','VARIANCE',35);
INSERT INTO TABLA_SINTAX VALUES ('expr_element','CHARTOROWID',35);
INSERT INTO TABLA_SINTAX VALUES ('expr_element','CONVERT',35);
INSERT INTO TABLA_SINTAX VALUES ('expr_element','HEXTORAW',35);
INSERT INTO TABLA_SINTAX VALUES ('expr_element','RAWTOHEX',35);
INSERT INTO TABLA_SINTAX VALUES ('expr_element','ROWIDTOCHAR',35);
INSERT INTO TABLA_SINTAX VALUES ('expr_element','TO_CHAR',35);
INSERT INTO TABLA_SINTAX VALUES ('expr_element','TO_DATE',35);
INSERT INTO TABLA_SINTAX VALUES ('expr_element','TO_NUMBER',35);
INSERT INTO TABLA_SINTAX VALUES ('expr_element','ADD_MONTHS',35);
INSERT INTO TABLA_SINTAX VALUES ('expr_element','LAST_DAY',35);
INSERT INTO TABLA_SINTAX VALUES ('expr_element','MONTHS_BETWEEN',35);
INSERT INTO TABLA_SINTAX VALUES ('expr_element','NEW_TIME',35);
INSERT INTO TABLA_SINTAX VALUES ('expr_element','NEXT_DAY',35);
INSERT INTO TABLA_SINTAX VALUES ('expr_element','ROUND',35);
INSERT INTO TABLA_SINTAX VALUES ('expr_element','TRUNC',35);
INSERT INTO TABLA_SINTAX VALUES ('expr_element','DUMP',35);
INSERT INTO TABLA_SINTAX VALUES ('expr_element','GREATEST',35);
INSERT INTO TABLA_SINTAX VALUES ('expr_element','LEAST',35);
INSERT INTO TABLA_SINTAX VALUES ('expr_element','NVL',35);
INSERT INTO TABLA_SINTAX VALUES ('expr_element','USERENV',35);
INSERT INTO TABLA_SINTAX VALUES ('expr_element','VSIZE',35);
INSERT INTO TABLA_SINTAX VALUES ('expr_element','DECODE',35);

--36/44: ctes   :   NUMERO | SYSDATE | UID | USER | TEXTO | LEVEL
--          |   NULL | UNDEFINED | UNKNOWN
INSERT INTO PRODUCCIONES VALUES (36,1,'NUMERO','T');
INSERT INTO PRODUCCIONES VALUES (37,1,'SYSDATE','T');
INSERT INTO PRODUCCIONES VALUES (38,1,'UID','T');
INSERT INTO PRODUCCIONES VALUES (39,1,'USER','T');
INSERT INTO PRODUCCIONES VALUES (40,1,'TEXTO','T');
INSERT INTO PRODUCCIONES VALUES (41,1,'LEVEL','T');
INSERT INTO PRODUCCIONES VALUES (42,1,'NULL','T');
INSERT INTO PRODUCCIONES VALUES (43,1,'UNDEFINED','T');
INSERT INTO PRODUCCIONES VALUES (44,1,'UNKNOWN','T');
INSERT INTO TABLA_SINTAX VALUES ('ctes','NUMERO',36);
INSERT INTO TABLA_SINTAX VALUES ('ctes','SYSDATE',37);
INSERT INTO TABLA_SINTAX VALUES ('ctes','UID',38);
INSERT INTO TABLA_SINTAX VALUES ('ctes','USER',39);
INSERT INTO TABLA_SINTAX VALUES ('ctes','TEXTO',40);
INSERT INTO TABLA_SINTAX VALUES ('ctes','LEVEL',41);
INSERT INTO TABLA_SINTAX VALUES ('ctes','NULL',42);
INSERT INTO TABLA_SINTAX VALUES ('ctes','UNDEFINED',43);
INSERT INTO TABLA_SINTAX VALUES ('ctes','UNKNOWN',44);

--45: expr_maxprior :   '+' expr_element
INSERT INTO PRODUCCIONES VALUES (45,1,'+','T');
INSERT INTO PRODUCCIONES VALUES (45,2,'expr_element','N');
INSERT INTO TABLA_SINTAX VALUES ('expr_maxprior','+',45);
--46        |   '-' expr_element
INSERT INTO PRODUCCIONES VALUES (46,1,'-','T');
INSERT INTO PRODUCCIONES VALUES (46,2,'expr_element','N');
INSERT INTO TABLA_SINTAX VALUES ('expr_maxprior','-',46);
--47        |   PRIOR expr_maxprior
INSERT INTO PRODUCCIONES VALUES (47,1,'PRIOR','T');
INSERT INTO PRODUCCIONES VALUES (47,2,'expr_maxprior','N');
INSERT INTO TABLA_SINTAX VALUES ('expr_maxprior','PRIOR',47);
--48        |   expr_element
INSERT INTO PRODUCCIONES VALUES (48,1,'expr_element','N');
-- Insertamos en TABLA_SINTAX: Iniciales(expr_element)
INSERT INTO TABLA_SINTAX VALUES ('expr_maxprior','(',48);
INSERT INTO TABLA_SINTAX VALUES ('expr_maxprior','{',48);
/* ctes */
INSERT INTO TABLA_SINTAX VALUES ('expr_maxprior','NUMERO',48);
INSERT INTO TABLA_SINTAX VALUES ('expr_maxprior','SYSDATE',48);
INSERT INTO TABLA_SINTAX VALUES ('expr_maxprior','UID',48);
INSERT INTO TABLA_SINTAX VALUES ('expr_maxprior','USER',48);
INSERT INTO TABLA_SINTAX VALUES ('expr_maxprior','TEXTO',48);
INSERT INTO TABLA_SINTAX VALUES ('expr_maxprior','LEVEL',48);
INSERT INTO TABLA_SINTAX VALUES ('expr_maxprior','NULL',48);
INSERT INTO TABLA_SINTAX VALUES ('expr_maxprior','UNDEFINED',48);
INSERT INTO TABLA_SINTAX VALUES ('expr_maxprior','UNKNOWN',48);
/* columna */
INSERT INTO TABLA_SINTAX VALUES ('expr_maxprior','ID',48);
INSERT INTO TABLA_SINTAX VALUES ('expr_maxprior','ROWID',48);
INSERT INTO TABLA_SINTAX VALUES ('expr_maxprior','ROWNUM',48);
/* funcion */
INSERT INTO TABLA_SINTAX VALUES ('expr_maxprior','ABS',48);
INSERT INTO TABLA_SINTAX VALUES ('expr_maxprior','CDEG',48);
INSERT INTO TABLA_SINTAX VALUES ('expr_maxprior','CEIL',48);
INSERT INTO TABLA_SINTAX VALUES ('expr_maxprior','FLOOR',48);
INSERT INTO TABLA_SINTAX VALUES ('expr_maxprior','SIGN',48);
INSERT INTO TABLA_SINTAX VALUES ('expr_maxprior','SQRT',48);
INSERT INTO TABLA_SINTAX VALUES ('expr_maxprior','CHR',48);
INSERT INTO TABLA_SINTAX VALUES ('expr_maxprior','MOD',48);
INSERT INTO TABLA_SINTAX VALUES ('expr_maxprior','POWER',48);
INSERT INTO TABLA_SINTAX VALUES ('expr_maxprior','INITCAP',48);
INSERT INTO TABLA_SINTAX VALUES ('expr_maxprior','LOWER',48);
INSERT INTO TABLA_SINTAX VALUES ('expr_maxprior','LPAD',48);
INSERT INTO TABLA_SINTAX VALUES ('expr_maxprior','LTRIM',48);
INSERT INTO TABLA_SINTAX VALUES ('expr_maxprior','REPLACE',48);
INSERT INTO TABLA_SINTAX VALUES ('expr_maxprior','RPAD',48);
INSERT INTO TABLA_SINTAX VALUES ('expr_maxprior','RTRIM',48);
INSERT INTO TABLA_SINTAX VALUES ('expr_maxprior','SOUNDEX',48);
INSERT INTO TABLA_SINTAX VALUES ('expr_maxprior','SUBSTR',48);
INSERT INTO TABLA_SINTAX VALUES ('expr_maxprior','TRANSLATE',48);
INSERT INTO TABLA_SINTAX VALUES ('expr_maxprior','UPPER',48);
INSERT INTO TABLA_SINTAX VALUES ('expr_maxprior','ASCII',48);
INSERT INTO TABLA_SINTAX VALUES ('expr_maxprior','INSTR',48);
INSERT INTO TABLA_SINTAX VALUES ('expr_maxprior','LENGTH',48);
INSERT INTO TABLA_SINTAX VALUES ('expr_maxprior','NLSSORT',48);
INSERT INTO TABLA_SINTAX VALUES ('expr_maxprior','AVG',48);
INSERT INTO TABLA_SINTAX VALUES ('expr_maxprior','COUNT',48);
INSERT INTO TABLA_SINTAX VALUES ('expr_maxprior','MAX',48);
INSERT INTO TABLA_SINTAX VALUES ('expr_maxprior','MIN',48);
INSERT INTO TABLA_SINTAX VALUES ('expr_maxprior','STDDEV',48);
INSERT INTO TABLA_SINTAX VALUES ('expr_maxprior','SUM',48);
INSERT INTO TABLA_SINTAX VALUES ('expr_maxprior','VARIANCE',48);
INSERT INTO TABLA_SINTAX VALUES ('expr_maxprior','CHARTOROWID',48);
INSERT INTO TABLA_SINTAX VALUES ('expr_maxprior','CONVERT',48);
INSERT INTO TABLA_SINTAX VALUES ('expr_maxprior','HEXTORAW',48);
INSERT INTO TABLA_SINTAX VALUES ('expr_maxprior','RAWTOHEX',48);
INSERT INTO TABLA_SINTAX VALUES ('expr_maxprior','ROWIDTOCHAR',48);
INSERT INTO TABLA_SINTAX VALUES ('expr_maxprior','TO_CHAR',48);
INSERT INTO TABLA_SINTAX VALUES ('expr_maxprior','TO_DATE',48);
INSERT INTO TABLA_SINTAX VALUES ('expr_maxprior','TO_NUMBER',48);
INSERT INTO TABLA_SINTAX VALUES ('expr_maxprior','ADD_MONTHS',48);
INSERT INTO TABLA_SINTAX VALUES ('expr_maxprior','LAST_DAY',48);
INSERT INTO TABLA_SINTAX VALUES ('expr_maxprior','MONTHS_BETWEEN',48);
INSERT INTO TABLA_SINTAX VALUES ('expr_maxprior','NEW_TIME',48);
INSERT INTO TABLA_SINTAX VALUES ('expr_maxprior','NEXT_DAY',48);
INSERT INTO TABLA_SINTAX VALUES ('expr_maxprior','ROUND',48);
INSERT INTO TABLA_SINTAX VALUES ('expr_maxprior','TRUNC',48);
INSERT INTO TABLA_SINTAX VALUES ('expr_maxprior','DUMP',48);
INSERT INTO TABLA_SINTAX VALUES ('expr_maxprior','GREATEST',48);
INSERT INTO TABLA_SINTAX VALUES ('expr_maxprior','LEAST',48);
INSERT INTO TABLA_SINTAX VALUES ('expr_maxprior','NVL',48);
INSERT INTO TABLA_SINTAX VALUES ('expr_maxprior','USERENV',48);
INSERT INTO TABLA_SINTAX VALUES ('expr_maxprior','VSIZE',48);
INSERT INTO TABLA_SINTAX VALUES ('expr_maxprior','DECODE',48);

--49: resto_expr    :   operacion resto_expr
INSERT INTO PRODUCCIONES VALUES (49,1,'operacion','N');
INSERT INTO PRODUCCIONES VALUES (49,2,'resto_expr','N');
INSERT INTO TABLA_SINTAX VALUES ('resto_expr','CONCAT',49);
INSERT INTO TABLA_SINTAX VALUES ('resto_expr','*',49);
INSERT INTO TABLA_SINTAX VALUES ('resto_expr','/',49);
INSERT INTO TABLA_SINTAX VALUES ('resto_expr','+',49);
INSERT INTO TABLA_SINTAX VALUES ('resto_expr','-',49);
--50        | {nulo}
INSERT INTO PRODUCCIONES VALUES (50,1,'VACIO','N');
--Poner los Seguidores(resto_expr)=Seguidores(expr)
INSERT INTO TABLA_SINTAX VALUES ('resto_expr',FIN,50);
INSERT INTO TABLA_SINTAX VALUES ('resto_expr',';',50);
INSERT INTO TABLA_SINTAX VALUES ('resto_expr',')',50);
INSERT INTO TABLA_SINTAX VALUES ('resto_expr','}',50);
INSERT INTO TABLA_SINTAX VALUES ('resto_expr','CADENA',50);
INSERT INTO TABLA_SINTAX VALUES ('resto_expr','ID',50);
INSERT INTO TABLA_SINTAX VALUES ('resto_expr','AS',50);
INSERT INTO TABLA_SINTAX VALUES ('resto_expr',',',50);
INSERT INTO TABLA_SINTAX VALUES ('resto_expr','FROM',50);
INSERT INTO TABLA_SINTAX VALUES ('resto_expr','IS',50);
INSERT INTO TABLA_SINTAX VALUES ('resto_expr','FEQ',50);
INSERT INTO TABLA_SINTAX VALUES ('resto_expr','FGT',50);
INSERT INTO TABLA_SINTAX VALUES ('resto_expr','FLT',50);
INSERT INTO TABLA_SINTAX VALUES ('resto_expr','FGEQ',50);
INSERT INTO TABLA_SINTAX VALUES ('resto_expr','FLEQ',50);
INSERT INTO TABLA_SINTAX VALUES ('resto_expr','MGT',50);
INSERT INTO TABLA_SINTAX VALUES ('resto_expr','MLT',50);
INSERT INTO TABLA_SINTAX VALUES ('resto_expr','NFEQ',50);
INSERT INTO TABLA_SINTAX VALUES ('resto_expr','NFGT',50);
INSERT INTO TABLA_SINTAX VALUES ('resto_expr','NFLT',50);
INSERT INTO TABLA_SINTAX VALUES ('resto_expr','NFGEQ',50);
INSERT INTO TABLA_SINTAX VALUES ('resto_expr','NFLEQ',50);
INSERT INTO TABLA_SINTAX VALUES ('resto_expr','NMGT',50);
INSERT INTO TABLA_SINTAX VALUES ('resto_expr','NMLT',50);
INSERT INTO TABLA_SINTAX VALUES ('resto_expr','NOT',50);
INSERT INTO TABLA_SINTAX VALUES ('resto_expr','IN',50);
INSERT INTO TABLA_SINTAX VALUES ('resto_expr','BETWEEN',50);
INSERT INTO TABLA_SINTAX VALUES ('resto_expr','EQ',50);
INSERT INTO TABLA_SINTAX VALUES ('resto_expr','NEQ',50);
INSERT INTO TABLA_SINTAX VALUES ('resto_expr','LEQ',50);
INSERT INTO TABLA_SINTAX VALUES ('resto_expr','GEQ',50);
INSERT INTO TABLA_SINTAX VALUES ('resto_expr','LT',50);
INSERT INTO TABLA_SINTAX VALUES ('resto_expr','GT',50);
INSERT INTO TABLA_SINTAX VALUES ('resto_expr','AND',50);
INSERT INTO TABLA_SINTAX VALUES ('resto_expr','OR',50);
INSERT INTO TABLA_SINTAX VALUES ('resto_expr','THOLD',50);
INSERT INTO TABLA_SINTAX VALUES ('resto_expr','NUMERO',50);
INSERT INTO TABLA_SINTAX VALUES ('resto_expr','ASC',50);
INSERT INTO TABLA_SINTAX VALUES ('resto_expr','DESC',50);
INSERT INTO TABLA_SINTAX VALUES ('resto_expr','GROUP',50);
INSERT INTO TABLA_SINTAX VALUES ('resto_expr','HAVING',50);
INSERT INTO TABLA_SINTAX VALUES ('resto_expr','START',50);
INSERT INTO TABLA_SINTAX VALUES ('resto_expr','CONNECT',50);
INSERT INTO TABLA_SINTAX VALUES ('resto_expr','ORDER',50);
INSERT INTO TABLA_SINTAX VALUES ('resto_expr','UNION',50);
INSERT INTO TABLA_SINTAX VALUES ('resto_expr','INTERSECT',50);
INSERT INTO TABLA_SINTAX VALUES ('resto_expr','MINUS',50);
INSERT INTO TABLA_SINTAX VALUES ('resto_expr','LIKE',50);

--51: operacion :   CONCAT expr_maxprior
INSERT INTO PRODUCCIONES VALUES (51,1,'CONCAT','T');
INSERT INTO PRODUCCIONES VALUES (51,2,'expr_element','N');
INSERT INTO TABLA_SINTAX VALUES ('operacion','CONCAT',51);
--52        |   '*' expr_maxprior
INSERT INTO PRODUCCIONES VALUES (52,1,'*','T');
INSERT INTO PRODUCCIONES VALUES (52,2,'expr_maxprior','N');
INSERT INTO TABLA_SINTAX VALUES ('operacion','*',52);
--53        |   '/' expr_maxprior
INSERT INTO PRODUCCIONES VALUES (53,1,'/','T');
INSERT INTO PRODUCCIONES VALUES (53,2,'expr_maxprior','N');
INSERT INTO TABLA_SINTAX VALUES ('operacion','/',53);
--54        |   '+' expr_maxprior
INSERT INTO PRODUCCIONES VALUES (54,1,'+','T');
INSERT INTO PRODUCCIONES VALUES (54,2,'expr_maxprior','N');
INSERT INTO TABLA_SINTAX VALUES ('operacion','+',54);
--55        |   '-' expr_maxprior
INSERT INTO PRODUCCIONES VALUES (55,1,'-','T');
INSERT INTO PRODUCCIONES VALUES (55,2,'expr_maxprior','N');
INSERT INTO TABLA_SINTAX VALUES ('operacion','-',55);
END;
/

DECLARE -- Bloque 2
  FIN CONSTANT PRODUCCIONES.parte_der%TYPE := 'THE END';
BEGIN
dbms_output.put_line('>>>> Tablas PRODUCCIONES y TABLA_SINTAX: Insertando valores... Bloque 2/3');

/*****> Definicin de una columna de una tabla <*****/
--60 columna    :   ID resto_col
INSERT INTO PRODUCCIONES VALUES (60,1,'ID','T');
INSERT INTO PRODUCCIONES VALUES (60,2,'resto_col','N');
INSERT INTO TABLA_SINTAX VALUES ('columna','ID',60);
--61        |   ROWID
INSERT INTO PRODUCCIONES VALUES (61,1,'ROWID','T');
INSERT INTO TABLA_SINTAX VALUES ('columna','ROWID',61);
--62        |   ROWNUM
INSERT INTO PRODUCCIONES VALUES (62,1,'ROWNUM','T');
INSERT INTO TABLA_SINTAX VALUES ('columna','ROWNUM',62);

--63 resto_col  :   '.' resto_col1
INSERT INTO PRODUCCIONES VALUES (63,1,'.','T');
INSERT INTO PRODUCCIONES VALUES (63,2,'resto_col1','N');
INSERT INTO TABLA_SINTAX VALUES ('resto_col','.',63);
--64        |
INSERT INTO PRODUCCIONES VALUES (64,1,'VACIO','T');
-- Seguidores(resto_col)=Seguidores(columna)
INSERT INTO TABLA_SINTAX VALUES ('resto_col','CONCAT',64);
INSERT INTO TABLA_SINTAX VALUES ('resto_col','+',64);
INSERT INTO TABLA_SINTAX VALUES ('resto_col','-',64);
INSERT INTO TABLA_SINTAX VALUES ('resto_col','/',64);
INSERT INTO TABLA_SINTAX VALUES ('resto_col','*',64);
-- Seg(expr):
INSERT INTO TABLA_SINTAX VALUES ('resto_col',FIN,64);
INSERT INTO TABLA_SINTAX VALUES ('resto_col',';',64);
INSERT INTO TABLA_SINTAX VALUES ('resto_col',')',64);
INSERT INTO TABLA_SINTAX VALUES ('resto_col','}',64);
INSERT INTO TABLA_SINTAX VALUES ('resto_col','CADENA',64);
INSERT INTO TABLA_SINTAX VALUES ('resto_col','ID',64);
INSERT INTO TABLA_SINTAX VALUES ('resto_col','AS',64);
INSERT INTO TABLA_SINTAX VALUES ('resto_col',',',64);
INSERT INTO TABLA_SINTAX VALUES ('resto_col','IS',64);
INSERT INTO TABLA_SINTAX VALUES ('resto_col','FEQ',64);
INSERT INTO TABLA_SINTAX VALUES ('resto_col','FGT',64);
INSERT INTO TABLA_SINTAX VALUES ('resto_col','FLT',64);
INSERT INTO TABLA_SINTAX VALUES ('resto_col','FGEQ',64);
INSERT INTO TABLA_SINTAX VALUES ('resto_col','FLEQ',64);
INSERT INTO TABLA_SINTAX VALUES ('resto_col','MGT',64);
INSERT INTO TABLA_SINTAX VALUES ('resto_col','MLT',64);
INSERT INTO TABLA_SINTAX VALUES ('resto_col','NFEQ',64);
INSERT INTO TABLA_SINTAX VALUES ('resto_col','NFGT',64);
INSERT INTO TABLA_SINTAX VALUES ('resto_col','NFLT',64);
INSERT INTO TABLA_SINTAX VALUES ('resto_col','NFGEQ',64);
INSERT INTO TABLA_SINTAX VALUES ('resto_col','NFLEQ',64);
INSERT INTO TABLA_SINTAX VALUES ('resto_col','NMGT',64);
INSERT INTO TABLA_SINTAX VALUES ('resto_col','NMLT',64);
INSERT INTO TABLA_SINTAX VALUES ('resto_col','NOT',64);
INSERT INTO TABLA_SINTAX VALUES ('resto_col','IN',64);
INSERT INTO TABLA_SINTAX VALUES ('resto_col','BETWEEN',64);
INSERT INTO TABLA_SINTAX VALUES ('resto_col','EQ',64);
INSERT INTO TABLA_SINTAX VALUES ('resto_col','NEQ',64);
INSERT INTO TABLA_SINTAX VALUES ('resto_col','LEQ',64);
INSERT INTO TABLA_SINTAX VALUES ('resto_col','GEQ',64);
INSERT INTO TABLA_SINTAX VALUES ('resto_col','LT',64);
INSERT INTO TABLA_SINTAX VALUES ('resto_col','GT',64);
INSERT INTO TABLA_SINTAX VALUES ('resto_col','AND',64);
INSERT INTO TABLA_SINTAX VALUES ('resto_col','OR',64);
INSERT INTO TABLA_SINTAX VALUES ('resto_col','THOLD',64);
INSERT INTO TABLA_SINTAX VALUES ('resto_col','NUMERO',64);
INSERT INTO TABLA_SINTAX VALUES ('resto_col','ASC',64);
INSERT INTO TABLA_SINTAX VALUES ('resto_col','FROM',64);
INSERT INTO TABLA_SINTAX VALUES ('resto_col','DESC',64);
INSERT INTO TABLA_SINTAX VALUES ('resto_col','GROUP',64);
INSERT INTO TABLA_SINTAX VALUES ('resto_col','HAVING',64);
INSERT INTO TABLA_SINTAX VALUES ('resto_col','START',64);
INSERT INTO TABLA_SINTAX VALUES ('resto_col','CONNECT',64);
INSERT INTO TABLA_SINTAX VALUES ('resto_col','ORDER',64);
INSERT INTO TABLA_SINTAX VALUES ('resto_col','UNION',64);
INSERT INTO TABLA_SINTAX VALUES ('resto_col','INTERSECT',64);
INSERT INTO TABLA_SINTAX VALUES ('resto_col','MINUS',64);
INSERT INTO TABLA_SINTAX VALUES ('resto_col','LIKE',64);

--65 resto_col1 :   ID resto_col2
INSERT INTO PRODUCCIONES VALUES (65,1,'ID','T');
INSERT INTO PRODUCCIONES VALUES (65,2,'resto_col2','N');
INSERT INTO TABLA_SINTAX VALUES ('resto_col1','ID',65);
--66        |   '*'
INSERT INTO PRODUCCIONES VALUES (66,1,'*','T');
INSERT INTO TABLA_SINTAX VALUES ('resto_col1','*',66);
--67        |   '%'
INSERT INTO PRODUCCIONES VALUES (67,1,'%','T');
INSERT INTO TABLA_SINTAX VALUES ('resto_col1','%',67);
--68        |   pseudo_col
INSERT INTO PRODUCCIONES VALUES (68,1,'pseudo_col','N');
INSERT INTO TABLA_SINTAX VALUES ('resto_col1','CURRVAL',68);
INSERT INTO TABLA_SINTAX VALUES ('resto_col1','NEXTVAL',68);
INSERT INTO TABLA_SINTAX VALUES ('resto_col1','LEVEL',68);
INSERT INTO TABLA_SINTAX VALUES ('resto_col1','ROWID',68);
INSERT INTO TABLA_SINTAX VALUES ('resto_col1','ROWNUM',68);

--69 resto_col2 :   '.' resto_col3
INSERT INTO PRODUCCIONES VALUES (69,1,'.','T');
INSERT INTO PRODUCCIONES VALUES (69,2,'resto_col3','N');
INSERT INTO TABLA_SINTAX VALUES ('resto_col2','.',69);
--70        |
INSERT INTO PRODUCCIONES VALUES (70,1,'VACIO','T');
-- Seguidores(resto_col2)=Seguidores(columna)
INSERT INTO TABLA_SINTAX VALUES ('resto_col2','CONCAT',70);
INSERT INTO TABLA_SINTAX VALUES ('resto_col2','+',70);
INSERT INTO TABLA_SINTAX VALUES ('resto_col2','-',70);
INSERT INTO TABLA_SINTAX VALUES ('resto_col2','/',70);
INSERT INTO TABLA_SINTAX VALUES ('resto_col2','*',70);
-- Seg(expr):
INSERT INTO TABLA_SINTAX VALUES ('resto_col2',FIN,70);
INSERT INTO TABLA_SINTAX VALUES ('resto_col2',';',70);
INSERT INTO TABLA_SINTAX VALUES ('resto_col2',')',70);
INSERT INTO TABLA_SINTAX VALUES ('resto_col2','}',70);
INSERT INTO TABLA_SINTAX VALUES ('resto_col2','CADENA',70);
INSERT INTO TABLA_SINTAX VALUES ('resto_col2','ID',70);
INSERT INTO TABLA_SINTAX VALUES ('resto_col2','AS',70);
INSERT INTO TABLA_SINTAX VALUES ('resto_col2',',',70);
INSERT INTO TABLA_SINTAX VALUES ('resto_col2','FROM',70);
INSERT INTO TABLA_SINTAX VALUES ('resto_col2','IS',70);
INSERT INTO TABLA_SINTAX VALUES ('resto_col2','FEQ',70);
INSERT INTO TABLA_SINTAX VALUES ('resto_col2','FGT',70);
INSERT INTO TABLA_SINTAX VALUES ('resto_col2','FLT',70);
INSERT INTO TABLA_SINTAX VALUES ('resto_col2','FGEQ',70);
INSERT INTO TABLA_SINTAX VALUES ('resto_col2','FLEQ',70);
INSERT INTO TABLA_SINTAX VALUES ('resto_col2','MGT',70);
INSERT INTO TABLA_SINTAX VALUES ('resto_col2','MLT',70);
INSERT INTO TABLA_SINTAX VALUES ('resto_col2','NFEQ',70);
INSERT INTO TABLA_SINTAX VALUES ('resto_col2','NFGT',70);
INSERT INTO TABLA_SINTAX VALUES ('resto_col2','NFLT',70);
INSERT INTO TABLA_SINTAX VALUES ('resto_col2','NFGEQ',70);
INSERT INTO TABLA_SINTAX VALUES ('resto_col2','NFLEQ',70);
INSERT INTO TABLA_SINTAX VALUES ('resto_col2','NMGT',70);
INSERT INTO TABLA_SINTAX VALUES ('resto_col2','NMLT',70);
INSERT INTO TABLA_SINTAX VALUES ('resto_col2','NOT',70);
INSERT INTO TABLA_SINTAX VALUES ('resto_col2','IN',70);
INSERT INTO TABLA_SINTAX VALUES ('resto_col2','BETWEEN',70);
INSERT INTO TABLA_SINTAX VALUES ('resto_col2','EQ',70);
INSERT INTO TABLA_SINTAX VALUES ('resto_col2','NEQ',70);
INSERT INTO TABLA_SINTAX VALUES ('resto_col2','LEQ',70);
INSERT INTO TABLA_SINTAX VALUES ('resto_col2','GEQ',70);
INSERT INTO TABLA_SINTAX VALUES ('resto_col2','LT',70);
INSERT INTO TABLA_SINTAX VALUES ('resto_col2','GT',70);
INSERT INTO TABLA_SINTAX VALUES ('resto_col2','AND',70);
INSERT INTO TABLA_SINTAX VALUES ('resto_col2','OR',70);
INSERT INTO TABLA_SINTAX VALUES ('resto_col2','THOLD',70);
INSERT INTO TABLA_SINTAX VALUES ('resto_col2','NUMERO',70);
INSERT INTO TABLA_SINTAX VALUES ('resto_col2','ASC',70);
INSERT INTO TABLA_SINTAX VALUES ('resto_col2','DESC',70);
INSERT INTO TABLA_SINTAX VALUES ('resto_col2','GROUP',70);
INSERT INTO TABLA_SINTAX VALUES ('resto_col2','HAVING',70);
INSERT INTO TABLA_SINTAX VALUES ('resto_col2','START',70);
INSERT INTO TABLA_SINTAX VALUES ('resto_col2','CONNECT',70);
INSERT INTO TABLA_SINTAX VALUES ('resto_col2','ORDER',70);
INSERT INTO TABLA_SINTAX VALUES ('resto_col2','UNION',70);
INSERT INTO TABLA_SINTAX VALUES ('resto_col2','INTERSECT',70);
INSERT INTO TABLA_SINTAX VALUES ('resto_col2','MINUS',70);
INSERT INTO TABLA_SINTAX VALUES ('resto_col2','LIKE',70);

--71/74: resto_col3 :   ID | '*' | '%' | pseudo_col
INSERT INTO PRODUCCIONES VALUES (71,1,'ID','T');
INSERT INTO TABLA_SINTAX VALUES ('resto_col3','ID',71);
INSERT INTO PRODUCCIONES VALUES (72,1,'*','T');
INSERT INTO TABLA_SINTAX VALUES ('resto_col3','*',72);
INSERT INTO PRODUCCIONES VALUES (73,1,'%','T');
INSERT INTO TABLA_SINTAX VALUES ('resto_col3','%',73);
INSERT INTO PRODUCCIONES VALUES (74,1,'pseudo_col','N');
INSERT INTO TABLA_SINTAX VALUES ('resto_col3','CURRVAL',74);
INSERT INTO TABLA_SINTAX VALUES ('resto_col3','NEXTVAL',74);
INSERT INTO TABLA_SINTAX VALUES ('resto_col3','LEVEL',74);
INSERT INTO TABLA_SINTAX VALUES ('resto_col3','ROWID',74);
INSERT INTO TABLA_SINTAX VALUES ('resto_col3','ROWNUM',74);

--75/79: pseudo_col :   CURRVAL | NEXTVAL | LEVEL | ROWID | ROWNUM
INSERT INTO PRODUCCIONES VALUES (75,1,'CURRVAL','T');
INSERT INTO TABLA_SINTAX VALUES ('pseudo_col','CURRVAL',75);
INSERT INTO PRODUCCIONES VALUES (76,1,'NEXTVAL','T');
INSERT INTO TABLA_SINTAX VALUES ('pseudo_col','NEXTVAL',76);
INSERT INTO PRODUCCIONES VALUES (77,1,'LEVEL','T');
INSERT INTO TABLA_SINTAX VALUES ('pseudo_col','LEVEL',77);
INSERT INTO PRODUCCIONES VALUES (78,1,'ROWID','T');
INSERT INTO TABLA_SINTAX VALUES ('pseudo_col','ROWID',78);
INSERT INTO PRODUCCIONES VALUES (79,1,'ROWNUM','T');
INSERT INTO TABLA_SINTAX VALUES ('pseudo_col','ROWNUM',79);

--90/96: funcion  :  ABS arg1|CDEG arg_dif|CEIL arg1|FLOOR arg1|SIGN arg1|SQRT arg1|CHR arg1
INSERT INTO PRODUCCIONES VALUES (90,1,'ABS','T');
INSERT INTO PRODUCCIONES VALUES (90,2,'arg1','N');
INSERT INTO PRODUCCIONES VALUES (91,1,'CDEG','T');
INSERT INTO PRODUCCIONES VALUES (91,2,'(','T');
INSERT INTO PRODUCCIONES VALUES (91,3,'arg_dif','N');
INSERT INTO PRODUCCIONES VALUES (91,4,')','T');
INSERT INTO PRODUCCIONES VALUES (92,1,'CEIL','T');
INSERT INTO PRODUCCIONES VALUES (92,2,'arg1','N');
INSERT INTO PRODUCCIONES VALUES (93,1,'FLOOR','T');
INSERT INTO PRODUCCIONES VALUES (93,2,'arg1','N');
INSERT INTO PRODUCCIONES VALUES (94,1,'SIGN','T');
INSERT INTO PRODUCCIONES VALUES (94,2,'arg1','N');
INSERT INTO PRODUCCIONES VALUES (95,1,'SQRT','T');
INSERT INTO PRODUCCIONES VALUES (95,2,'arg1','N');
INSERT INTO PRODUCCIONES VALUES (96,1,'CHR','T');
INSERT INTO PRODUCCIONES VALUES (96,2,'arg1','N');
--97/103 :|MOD arg2|POWER arg2|INITCAP arg1|LOWER arg1|LPAD arg2_3|LTRIM arg1_2|REPLACE arg2_3
INSERT INTO PRODUCCIONES VALUES (97,1,'MOD','T');
INSERT INTO PRODUCCIONES VALUES (97,2,'arg2','N');
INSERT INTO PRODUCCIONES VALUES (98,1,'POWER','T');
INSERT INTO PRODUCCIONES VALUES (98,2,'arg2','N');
INSERT INTO PRODUCCIONES VALUES (99,1,'INITCAP','T');
INSERT INTO PRODUCCIONES VALUES (99,2,'arg1','N');
INSERT INTO PRODUCCIONES VALUES (100,1,'LOWER','T');
INSERT INTO PRODUCCIONES VALUES (100,2,'arg1','N');
INSERT INTO PRODUCCIONES VALUES (101,1,'LPAD','T');
INSERT INTO PRODUCCIONES VALUES (101,2,'arg2_3','N');
INSERT INTO PRODUCCIONES VALUES (102,1,'LTRIM','T');
INSERT INTO PRODUCCIONES VALUES (102,2,'arg1_2','N');
INSERT INTO PRODUCCIONES VALUES (103,1,'REPLACE','T');
INSERT INTO PRODUCCIONES VALUES (103,2,'arg2_3','N');
--104/109:|RPAD arg2_3|RTRIM arg1_2|SOUNDEX arg1|SUBSTR arg2_3|TRANSLATE arg3|UPPER arg1
INSERT INTO PRODUCCIONES VALUES (104,1,'RPAD','T');
INSERT INTO PRODUCCIONES VALUES (104,2,'arg2_3','N');
INSERT INTO PRODUCCIONES VALUES (105,1,'RTRIM','T');
INSERT INTO PRODUCCIONES VALUES (105,2,'arg1_2','N');
INSERT INTO PRODUCCIONES VALUES (106,1,'SOUNDEX','T');
INSERT INTO PRODUCCIONES VALUES (106,2,'arg1','N');
INSERT INTO PRODUCCIONES VALUES (107,1,'SUBSTR','T');
INSERT INTO PRODUCCIONES VALUES (107,2,'arg2_3','N');
INSERT INTO PRODUCCIONES VALUES (108,1,'TRANSLATE','T');
INSERT INTO PRODUCCIONES VALUES (108,2,'arg3','N');
INSERT INTO PRODUCCIONES VALUES (109,1,'UPPER','T');
INSERT INTO PRODUCCIONES VALUES (109,2,'arg1','N');
--110/115:|ASCII arg1|INSTR arg2_3_4|LENGTH arg1|NLSSORT arg1|AVG arg1u|COUNT arg2u
INSERT INTO PRODUCCIONES VALUES (110,1,'ASCII','T');
INSERT INTO PRODUCCIONES VALUES (110,2,'arg1','N');
INSERT INTO PRODUCCIONES VALUES (111,1,'INSTR','T');
INSERT INTO PRODUCCIONES VALUES (111,2,'arg2_3_4','N');
INSERT INTO PRODUCCIONES VALUES (112,1,'LENGTH','T');
INSERT INTO PRODUCCIONES VALUES (112,2,'arg1','N');
INSERT INTO PRODUCCIONES VALUES (113,1,'NLSSORT','T');
INSERT INTO PRODUCCIONES VALUES (113,2,'arg1','N');
INSERT INTO PRODUCCIONES VALUES (114,1,'AVG','T');
INSERT INTO PRODUCCIONES VALUES (114,2,'arg1u','N');
INSERT INTO PRODUCCIONES VALUES (115,1,'COUNT','T');
INSERT INTO PRODUCCIONES VALUES (115,2,'arg2u','N');
--116/121:|MAX arg1u|MIN arg1u|STDDEV arg1u|SUM arg1u|VARIANCE arg1u|CHARTOROWID arg1
INSERT INTO PRODUCCIONES VALUES (116,1,'MAX','T');
INSERT INTO PRODUCCIONES VALUES (116,2,'arg1u','N');
INSERT INTO PRODUCCIONES VALUES (117,1,'MIN','T');
INSERT INTO PRODUCCIONES VALUES (117,2,'arg1u','N');
INSERT INTO PRODUCCIONES VALUES (118,1,'STDDEV','T');
INSERT INTO PRODUCCIONES VALUES (118,2,'arg1u','N');
INSERT INTO PRODUCCIONES VALUES (119,1,'SUM','T');
INSERT INTO PRODUCCIONES VALUES (119,2,'arg1u','N');
INSERT INTO PRODUCCIONES VALUES (120,1,'VARIANCE','T');
INSERT INTO PRODUCCIONES VALUES (120,2,'arg1u','N');
INSERT INTO PRODUCCIONES VALUES (121,1,'CHARTOROWID','T');
INSERT INTO PRODUCCIONES VALUES (121,2,'arg1','N');
--122/126:|CONVERT arg1_2_3|HEXTORAW arg1|RAWTOHEX arg1|ROWIDTOCHAR arg1|TO_CHAR arg1_2
INSERT INTO PRODUCCIONES VALUES (122,1,'CONVERT','T');
INSERT INTO PRODUCCIONES VALUES (122,2,'arg1_2_3','N');
INSERT INTO PRODUCCIONES VALUES (123,1,'HEXTORAW','T');
INSERT INTO PRODUCCIONES VALUES (123,2,'arg1','N');
INSERT INTO PRODUCCIONES VALUES (124,1,'RAWTOHEX','T');
INSERT INTO PRODUCCIONES VALUES (124,2,'arg1','N');
INSERT INTO PRODUCCIONES VALUES (125,1,'ROWIDTOCHAR','T');
INSERT INTO PRODUCCIONES VALUES (125,2,'arg1','N');
INSERT INTO PRODUCCIONES VALUES (126,1,'TO_CHAR','T');
INSERT INTO PRODUCCIONES VALUES (126,2,'arg1_2','N');
--127/131:|TO_DATE arg1_2|TO_NUMBER arg1|ADD_MONTHS arg2|LAST_DAY arg1|MONTHS_BETWEEN arg2
INSERT INTO PRODUCCIONES VALUES (127,1,'TO_DATE','T');
INSERT INTO PRODUCCIONES VALUES (127,2,'arg1_2','N');
INSERT INTO PRODUCCIONES VALUES (128,1,'TO_NUMBER','T');
INSERT INTO PRODUCCIONES VALUES (128,2,'arg1','N');
INSERT INTO PRODUCCIONES VALUES (129,1,'ADD_MONTHS','T');
INSERT INTO PRODUCCIONES VALUES (129,2,'arg2','N');
INSERT INTO PRODUCCIONES VALUES (130,1,'LAST_DAY','T');
INSERT INTO PRODUCCIONES VALUES (130,2,'arg1','N');
INSERT INTO PRODUCCIONES VALUES (131,1,'MONTHS_BETWEEN','T');
INSERT INTO PRODUCCIONES VALUES (131,2,'arg2','N');
--132/136:|NEW_TIME arg3|NEXT_DAY arg2|ROUND arg1_2|TRUNC arg1_2|DUMP arg1_2_3_4
INSERT INTO PRODUCCIONES VALUES (132,1,'NEW_TIME','T');
INSERT INTO PRODUCCIONES VALUES (132,2,'arg3','N');
INSERT INTO PRODUCCIONES VALUES (133,1,'NEXT_DAY','T');
INSERT INTO PRODUCCIONES VALUES (133,2,'arg2','N');
INSERT INTO PRODUCCIONES VALUES (134,1,'ROUND','T');
INSERT INTO PRODUCCIONES VALUES (134,2,'arg1_2','N');
INSERT INTO PRODUCCIONES VALUES (135,1,'TRUNC','T');
INSERT INTO PRODUCCIONES VALUES (135,2,'arg1_2','N');
INSERT INTO PRODUCCIONES VALUES (136,1,'DUMP','T');
INSERT INTO PRODUCCIONES VALUES (136,2,'arg1_2_3_4','N');
--137/142:|GREATEST arg_list|LEAST arg_list|NVL arg2|USERENV arg1|VSIZE arg1|DECODE argu_deco
INSERT INTO PRODUCCIONES VALUES (137,1,'GREATEST','T');
INSERT INTO PRODUCCIONES VALUES (137,2,'arg_list','N');
INSERT INTO PRODUCCIONES VALUES (138,1,'LEAST','T');
INSERT INTO PRODUCCIONES VALUES (138,2,'arg_list','N');
INSERT INTO PRODUCCIONES VALUES (139,1,'NVL','T');
INSERT INTO PRODUCCIONES VALUES (139,2,'arg2','N');
INSERT INTO PRODUCCIONES VALUES (140,1,'USERENV','T');
INSERT INTO PRODUCCIONES VALUES (140,2,'arg1','N');
INSERT INTO PRODUCCIONES VALUES (141,1,'VSIZE','T');
INSERT INTO PRODUCCIONES VALUES (141,2,'arg1','N');
INSERT INTO PRODUCCIONES VALUES (142,1,'DECODE','T');
INSERT INTO PRODUCCIONES VALUES (142,2,'argu_deco','N');
-- Tuplas para las transiciones, si en la pila est el smbolo 'funcion':
INSERT INTO TABLA_SINTAX VALUES ('funcion','ABS',90);
INSERT INTO TABLA_SINTAX VALUES ('funcion','CDEG',91);
INSERT INTO TABLA_SINTAX VALUES ('funcion','CEIL',92);
INSERT INTO TABLA_SINTAX VALUES ('funcion','FLOOR',93);
INSERT INTO TABLA_SINTAX VALUES ('funcion','SIGN',94);
INSERT INTO TABLA_SINTAX VALUES ('funcion','SQRT',95);
INSERT INTO TABLA_SINTAX VALUES ('funcion','CHR',96);
INSERT INTO TABLA_SINTAX VALUES ('funcion','MOD',97);
INSERT INTO TABLA_SINTAX VALUES ('funcion','POWER',98);
INSERT INTO TABLA_SINTAX VALUES ('funcion','INITCAP',99);
INSERT INTO TABLA_SINTAX VALUES ('funcion','LOWER',100);
INSERT INTO TABLA_SINTAX VALUES ('funcion','LPAD',101);
INSERT INTO TABLA_SINTAX VALUES ('funcion','LTRIM',102);
INSERT INTO TABLA_SINTAX VALUES ('funcion','REPLACE',103);
INSERT INTO TABLA_SINTAX VALUES ('funcion','RPAD',104);
INSERT INTO TABLA_SINTAX VALUES ('funcion','RTRIM',105);
INSERT INTO TABLA_SINTAX VALUES ('funcion','SOUNDEX',106);
INSERT INTO TABLA_SINTAX VALUES ('funcion','SUBSTR',107);
INSERT INTO TABLA_SINTAX VALUES ('funcion','TRANSLATE',108);
INSERT INTO TABLA_SINTAX VALUES ('funcion','UPPER',109);
INSERT INTO TABLA_SINTAX VALUES ('funcion','ASCII',110);
INSERT INTO TABLA_SINTAX VALUES ('funcion','INSTR',111);
INSERT INTO TABLA_SINTAX VALUES ('funcion','LENGTH',112);
INSERT INTO TABLA_SINTAX VALUES ('funcion','NLSSORT',113);
INSERT INTO TABLA_SINTAX VALUES ('funcion','AVG',114);
INSERT INTO TABLA_SINTAX VALUES ('funcion','COUNT',115);
INSERT INTO TABLA_SINTAX VALUES ('funcion','MAX',116);
INSERT INTO TABLA_SINTAX VALUES ('funcion','MIN',117);
INSERT INTO TABLA_SINTAX VALUES ('funcion','STDDEV',118);
INSERT INTO TABLA_SINTAX VALUES ('funcion','SUM',119);
INSERT INTO TABLA_SINTAX VALUES ('funcion','VARIANCE',120);
INSERT INTO TABLA_SINTAX VALUES ('funcion','CHARTOROWID',121);
INSERT INTO TABLA_SINTAX VALUES ('funcion','CONVERT',122);
INSERT INTO TABLA_SINTAX VALUES ('funcion','HEXTORAW',123);
INSERT INTO TABLA_SINTAX VALUES ('funcion','RAWTOHEX',124);
INSERT INTO TABLA_SINTAX VALUES ('funcion','ROWIDTOCHAR',125);
INSERT INTO TABLA_SINTAX VALUES ('funcion','TO_CHAR',126);
INSERT INTO TABLA_SINTAX VALUES ('funcion','TO_DATE',127);
INSERT INTO TABLA_SINTAX VALUES ('funcion','TO_NUMBER',128);
INSERT INTO TABLA_SINTAX VALUES ('funcion','ADD_MONTHS',129);
INSERT INTO TABLA_SINTAX VALUES ('funcion','LAST_DAY',130);
INSERT INTO TABLA_SINTAX VALUES ('funcion','MONTHS_BETWEEN',131);
INSERT INTO TABLA_SINTAX VALUES ('funcion','NEW_TIME',132);
INSERT INTO TABLA_SINTAX VALUES ('funcion','NEXT_DAY',133);
INSERT INTO TABLA_SINTAX VALUES ('funcion','ROUND',134);
INSERT INTO TABLA_SINTAX VALUES ('funcion','TRUNC',135);
INSERT INTO TABLA_SINTAX VALUES ('funcion','DUMP',136);
INSERT INTO TABLA_SINTAX VALUES ('funcion','GREATEST',137);
INSERT INTO TABLA_SINTAX VALUES ('funcion','LEAST',138);
INSERT INTO TABLA_SINTAX VALUES ('funcion','NVL',139);
INSERT INTO TABLA_SINTAX VALUES ('funcion','USERENV',140);
INSERT INTO TABLA_SINTAX VALUES ('funcion','VSIZE',141);
INSERT INTO TABLA_SINTAX VALUES ('funcion','DECODE',142);

--149/150: arg_dif: '*' | columna
INSERT INTO PRODUCCIONES VALUES (149,1,'*','T');
INSERT INTO TABLA_SINTAX VALUES ('arg_dif','*',149);
INSERT INTO PRODUCCIONES VALUES (150,1,'columna','N');
-- Iniciales(columna)-{ROWID,ROWNUM}
INSERT INTO TABLA_SINTAX VALUES ('arg_dif','ID',150);

--151: arg1 :   '(' expr ')'
INSERT INTO PRODUCCIONES VALUES (151,1,'(','T');
INSERT INTO PRODUCCIONES VALUES (151,2,'expr','N');
INSERT INTO PRODUCCIONES VALUES (151,3,')','T');
INSERT INTO TABLA_SINTAX VALUES ('arg1','(',151);

--152: arg2 :   '(' expr ',' expr ')'
INSERT INTO PRODUCCIONES VALUES (152,1,'(','T');
INSERT INTO PRODUCCIONES VALUES (152,2,'expr','N');
INSERT INTO PRODUCCIONES VALUES (152,3,',','T');
INSERT INTO PRODUCCIONES VALUES (152,4,'expr','N');
INSERT INTO PRODUCCIONES VALUES (152,5,')','T');
INSERT INTO TABLA_SINTAX VALUES ('arg2','(',152);

--153: arg3 :   '(' expr ',' expr ',' expr ')'
INSERT INTO PRODUCCIONES VALUES (153,1,'(','T');
INSERT INTO PRODUCCIONES VALUES (153,2,'expr','N');
INSERT INTO PRODUCCIONES VALUES (153,3,',','T');
INSERT INTO PRODUCCIONES VALUES (153,4,'expr','N');
INSERT INTO PRODUCCIONES VALUES (153,5,',','T');
INSERT INTO PRODUCCIONES VALUES (153,6,'expr','N');
INSERT INTO PRODUCCIONES VALUES (153,7,')','T');
INSERT INTO TABLA_SINTAX VALUES ('arg3','(',153);

--154: arg1_2:  '(' expr list_op1 ')'
INSERT INTO PRODUCCIONES VALUES (154,1,'(','T');
INSERT INTO PRODUCCIONES VALUES (154,2,'expr','N');
INSERT INTO PRODUCCIONES VALUES (154,3,'list_op1','N');
INSERT INTO PRODUCCIONES VALUES (154,4,')','T');
INSERT INTO TABLA_SINTAX VALUES ('arg1_2','(',154);

--155: arg2_3:  '(' expr ',' expr list_op1 ')'
INSERT INTO PRODUCCIONES VALUES (155,1,'(','T');
INSERT INTO PRODUCCIONES VALUES (155,2,'expr','N');
INSERT INTO PRODUCCIONES VALUES (155,3,',','T');
INSERT INTO PRODUCCIONES VALUES (155,4,'expr','N');
INSERT INTO PRODUCCIONES VALUES (155,5,'list_op1','N');
INSERT INTO PRODUCCIONES VALUES (155,6,')','T');
INSERT INTO TABLA_SINTAX VALUES ('arg2_3','(',155);

--156: arg1_2_3:    '(' expr list_op2 ')'
INSERT INTO PRODUCCIONES VALUES (156,1,'(','T');
INSERT INTO PRODUCCIONES VALUES (156,2,'expr','N');
INSERT INTO PRODUCCIONES VALUES (156,3,'list_op2','N');
INSERT INTO PRODUCCIONES VALUES (156,4,')','T');
INSERT INTO TABLA_SINTAX VALUES ('arg1_2_3','(',156);

--157: arg2_3_4:    '(' expr ',' expr list_op2 ')'
INSERT INTO PRODUCCIONES VALUES (157,1,'(','T');
INSERT INTO PRODUCCIONES VALUES (157,2,'expr','N');
INSERT INTO PRODUCCIONES VALUES (157,3,',','T');
INSERT INTO PRODUCCIONES VALUES (157,4,'expr','N');
INSERT INTO PRODUCCIONES VALUES (157,5,'list_op2','N');
INSERT INTO PRODUCCIONES VALUES (157,6,')','T');
INSERT INTO TABLA_SINTAX VALUES ('arg2_3_4','(',157);

--158: arg1_2_3_4   :   '(' expr list_op3 ')'
INSERT INTO PRODUCCIONES VALUES (158,1,'(','T');
INSERT INTO PRODUCCIONES VALUES (158,2,'expr','N');
INSERT INTO PRODUCCIONES VALUES (158,3,'list_op3','N');
INSERT INTO PRODUCCIONES VALUES (158,4,')','T');
INSERT INTO TABLA_SINTAX VALUES ('arg1_2_3_4','(',158);

--159: list_op1 :   ',' expr
INSERT INTO PRODUCCIONES VALUES (159,1,',','T');
INSERT INTO PRODUCCIONES VALUES (159,2,'expr','N');
INSERT INTO TABLA_SINTAX VALUES ('list_op1',',',159);
--160:      |
INSERT INTO PRODUCCIONES VALUES (160,1,'VACIO','N');
--Seguidores(list_op1)=Seguidores(list_op2)=Seguidores(list_op3)=')'
INSERT INTO TABLA_SINTAX VALUES ('list_op1',')',160);

--161: list_op2 :   ',' expr list_op1
INSERT INTO PRODUCCIONES VALUES (161,1,',','T');
INSERT INTO PRODUCCIONES VALUES (161,2,'list_op1','N');
INSERT INTO TABLA_SINTAX VALUES ('list_op2',',',161);
--162:      |
INSERT INTO PRODUCCIONES VALUES (162,1,'VACIO','N');
INSERT INTO TABLA_SINTAX VALUES ('list_op2',')',162);

--163: list_op3 :   ',' expr list_op2
INSERT INTO PRODUCCIONES VALUES (163,1,',','T');
INSERT INTO PRODUCCIONES VALUES (163,2,'expr','N');
INSERT INTO PRODUCCIONES VALUES (163,3,'list_op2','N');
INSERT INTO TABLA_SINTAX VALUES ('list_op3',',',163);
--164:      |
INSERT INTO PRODUCCIONES VALUES (164,1,'VACIO','N');
INSERT INTO TABLA_SINTAX VALUES ('list_op3',')',164);

--165: arg_list :   '(' expr mas_expres ')'
INSERT INTO PRODUCCIONES VALUES (165,1,'(','T');
INSERT INTO PRODUCCIONES VALUES (165,2,'expr','N');
INSERT INTO PRODUCCIONES VALUES (165,3,'mas_expres','N');
INSERT INTO PRODUCCIONES VALUES (165,4,')','T');
INSERT INTO TABLA_SINTAX VALUES ('arg_list','(',165);

--166: mas_expres   :   ',' expr mas_expres
INSERT INTO PRODUCCIONES VALUES (166,1,',','T');
INSERT INTO PRODUCCIONES VALUES (166,2,'expr','N');
INSERT INTO PRODUCCIONES VALUES (166,3,'mas_expres','N');
INSERT INTO TABLA_SINTAX VALUES ('mas_expres',',',166);
--167:      |
INSERT INTO PRODUCCIONES VALUES (167,1,'VACIO','N');
-- Seguidores(mas_expres)
INSERT INTO TABLA_SINTAX VALUES ('mas_expres',FIN,167);
INSERT INTO TABLA_SINTAX VALUES ('mas_expres',';',167);
INSERT INTO TABLA_SINTAX VALUES ('mas_expres',')',167);
INSERT INTO TABLA_SINTAX VALUES ('mas_expres','HAVING',167);
INSERT INTO TABLA_SINTAX VALUES ('mas_expres','GROUP',167);
INSERT INTO TABLA_SINTAX VALUES ('mas_expres','START',167);
INSERT INTO TABLA_SINTAX VALUES ('mas_expres','CONNECT',167);
INSERT INTO TABLA_SINTAX VALUES ('mas_expres','UNION',167);
INSERT INTO TABLA_SINTAX VALUES ('mas_expres','INTERSECT',167);
INSERT INTO TABLA_SINTAX VALUES ('mas_expres','MINUS',167);
INSERT INTO TABLA_SINTAX VALUES ('mas_expres','ORDER',167);

--168/169: dupli    :   DISTINCT | ALL
INSERT INTO PRODUCCIONES VALUES (168,1,'DISTINCT','T');
INSERT INTO PRODUCCIONES VALUES (169,1,'ALL','T');
INSERT INTO TABLA_SINTAX VALUES ('dupli','DISTINCT',168);
INSERT INTO TABLA_SINTAX VALUES ('dupli','ALL',169);
--170:      |
INSERT INTO PRODUCCIONES VALUES (170,1,'VACIO','N');
-- Seguidores(dupli)=Iniciales(expr)
INSERT INTO TABLA_SINTAX VALUES ('dupli','+',170);
INSERT INTO TABLA_SINTAX VALUES ('dupli','-',170);
INSERT INTO TABLA_SINTAX VALUES ('dupli','PRIOR',170);
INSERT INTO TABLA_SINTAX VALUES ('dupli','(',170);
INSERT INTO TABLA_SINTAX VALUES ('dupli','{',170);
/* ctes */
INSERT INTO TABLA_SINTAX VALUES ('dupli','NUMERO',170);
INSERT INTO TABLA_SINTAX VALUES ('dupli','SYSDATE',170);
INSERT INTO TABLA_SINTAX VALUES ('dupli','UID',170);
INSERT INTO TABLA_SINTAX VALUES ('dupli','USER',170);
INSERT INTO TABLA_SINTAX VALUES ('dupli','TEXTO',170);
INSERT INTO TABLA_SINTAX VALUES ('dupli','LEVEL',170);
INSERT INTO TABLA_SINTAX VALUES ('dupli','NULL',170);
INSERT INTO TABLA_SINTAX VALUES ('dupli','UNDEFINED',170);
INSERT INTO TABLA_SINTAX VALUES ('dupli','UNKNOWN',170);
/* columna */
INSERT INTO TABLA_SINTAX VALUES ('dupli','ID',170);
INSERT INTO TABLA_SINTAX VALUES ('dupli','ROWID',170);
INSERT INTO TABLA_SINTAX VALUES ('dupli','ROWNUM',170);
/* funciones */
INSERT INTO TABLA_SINTAX VALUES ('dupli','ABS',170);
INSERT INTO TABLA_SINTAX VALUES ('dupli','CDEG',170);
INSERT INTO TABLA_SINTAX VALUES ('dupli','CEIL',170);
INSERT INTO TABLA_SINTAX VALUES ('dupli','FLOOR',170);
INSERT INTO TABLA_SINTAX VALUES ('dupli','SIGN',170);
INSERT INTO TABLA_SINTAX VALUES ('dupli','SQRT',170);
INSERT INTO TABLA_SINTAX VALUES ('dupli','CHR',170);
INSERT INTO TABLA_SINTAX VALUES ('dupli','MOD',170);
INSERT INTO TABLA_SINTAX VALUES ('dupli','POWER',170);
INSERT INTO TABLA_SINTAX VALUES ('dupli','INITCAP',170);
INSERT INTO TABLA_SINTAX VALUES ('dupli','LOWER',170);
INSERT INTO TABLA_SINTAX VALUES ('dupli','LPAD',170);
INSERT INTO TABLA_SINTAX VALUES ('dupli','LTRIM',170);
INSERT INTO TABLA_SINTAX VALUES ('dupli','REPLACE',170);
INSERT INTO TABLA_SINTAX VALUES ('dupli','RPAD',170);
INSERT INTO TABLA_SINTAX VALUES ('dupli','RTRIM',170);
INSERT INTO TABLA_SINTAX VALUES ('dupli','SOUNDEX',170);
INSERT INTO TABLA_SINTAX VALUES ('dupli','SUBSTR',170);
INSERT INTO TABLA_SINTAX VALUES ('dupli','TRANSLATE',170);
INSERT INTO TABLA_SINTAX VALUES ('dupli','UPPER',170);
INSERT INTO TABLA_SINTAX VALUES ('dupli','ASCII',170);
INSERT INTO TABLA_SINTAX VALUES ('dupli','INSTR',170);
INSERT INTO TABLA_SINTAX VALUES ('dupli','LENGTH',170);
INSERT INTO TABLA_SINTAX VALUES ('dupli','NLSSORT',170);
INSERT INTO TABLA_SINTAX VALUES ('dupli','AVG',170);
INSERT INTO TABLA_SINTAX VALUES ('dupli','COUNT',170);
INSERT INTO TABLA_SINTAX VALUES ('dupli','MAX',170);
INSERT INTO TABLA_SINTAX VALUES ('dupli','MIN',170);
INSERT INTO TABLA_SINTAX VALUES ('dupli','STDDEV',170);
INSERT INTO TABLA_SINTAX VALUES ('dupli','SUM',170);
INSERT INTO TABLA_SINTAX VALUES ('dupli','VARIANCE',170);
INSERT INTO TABLA_SINTAX VALUES ('dupli','CHARTOROWID',170);
INSERT INTO TABLA_SINTAX VALUES ('dupli','CONVERT',170);
INSERT INTO TABLA_SINTAX VALUES ('dupli','HEXTORAW',170);
INSERT INTO TABLA_SINTAX VALUES ('dupli','RAWTOHEX',170);
INSERT INTO TABLA_SINTAX VALUES ('dupli','ROWIDTOCHAR',170);
INSERT INTO TABLA_SINTAX VALUES ('dupli','TO_CHAR',170);
INSERT INTO TABLA_SINTAX VALUES ('dupli','TO_DATE',170);
INSERT INTO TABLA_SINTAX VALUES ('dupli','TO_NUMBER',170);
INSERT INTO TABLA_SINTAX VALUES ('dupli','ADD_MONTHS',170);
INSERT INTO TABLA_SINTAX VALUES ('dupli','LAST_DAY',170);
INSERT INTO TABLA_SINTAX VALUES ('dupli','MONTHS_BETWEEN',170);
INSERT INTO TABLA_SINTAX VALUES ('dupli','NEW_TIME',170);
INSERT INTO TABLA_SINTAX VALUES ('dupli','NEXT_DAY',170);
INSERT INTO TABLA_SINTAX VALUES ('dupli','ROUND',170);
INSERT INTO TABLA_SINTAX VALUES ('dupli','TRUNC',170);
INSERT INTO TABLA_SINTAX VALUES ('dupli','DUMP',170);
INSERT INTO TABLA_SINTAX VALUES ('dupli','GREATEST',170);
INSERT INTO TABLA_SINTAX VALUES ('dupli','LEAST',170);
INSERT INTO TABLA_SINTAX VALUES ('dupli','NVL',170);
INSERT INTO TABLA_SINTAX VALUES ('dupli','USERENV',170);
INSERT INTO TABLA_SINTAX VALUES ('dupli','VSIZE',170);
INSERT INTO TABLA_SINTAX VALUES ('dupli','DECODE',170);

--171: arg1u    :   '(' dupli expr ')'
INSERT INTO PRODUCCIONES VALUES (171,1,'(','T');
INSERT INTO PRODUCCIONES VALUES (171,2,'dupli','N');
INSERT INTO PRODUCCIONES VALUES (171,3,'expr','N');
INSERT INTO PRODUCCIONES VALUES (171,4,')','T');
INSERT INTO TABLA_SINTAX VALUES ('arg1u','(',171);

--172: arg2u    :   '(' resto_arg2u ')'
INSERT INTO PRODUCCIONES VALUES (172,1,'(','T');
INSERT INTO PRODUCCIONES VALUES (172,2,'resto_arg2u','N');
INSERT INTO PRODUCCIONES VALUES (172,3,')','T');
INSERT INTO TABLA_SINTAX VALUES ('arg2u','(',172);

--173: resto_arg2u: dupli expr
INSERT INTO PRODUCCIONES VALUES (173,1,'dupli','N');
INSERT INTO PRODUCCIONES VALUES (173,2,'expr','N');
INSERT INTO TABLA_SINTAX VALUES ('resto_arg2u','DISTINCT',173);
INSERT INTO TABLA_SINTAX VALUES ('resto_arg2u','ALL',173);
-- Iniciales(expr) (porque dupli puede derivar en VACIO)
INSERT INTO TABLA_SINTAX VALUES ('resto_arg2u','+',173);
INSERT INTO TABLA_SINTAX VALUES ('resto_arg2u','-',173);
INSERT INTO TABLA_SINTAX VALUES ('resto_arg2u','PRIOR',173);
INSERT INTO TABLA_SINTAX VALUES ('resto_arg2u','(',173);
INSERT INTO TABLA_SINTAX VALUES ('resto_arg2u','{',173);
/* ctes */
INSERT INTO TABLA_SINTAX VALUES ('resto_arg2u','NUMERO',173);
INSERT INTO TABLA_SINTAX VALUES ('resto_arg2u','SYSDATE',173);
INSERT INTO TABLA_SINTAX VALUES ('resto_arg2u','UID',173);
INSERT INTO TABLA_SINTAX VALUES ('resto_arg2u','USER',173);
INSERT INTO TABLA_SINTAX VALUES ('resto_arg2u','TEXTO',173);
INSERT INTO TABLA_SINTAX VALUES ('resto_arg2u','LEVEL',173);
INSERT INTO TABLA_SINTAX VALUES ('resto_arg2u','NULL',173);
INSERT INTO TABLA_SINTAX VALUES ('resto_arg2u','UNDEFINED',173);
INSERT INTO TABLA_SINTAX VALUES ('resto_arg2u','UNKNOWN',173);
/* columna */
INSERT INTO TABLA_SINTAX VALUES ('resto_arg2u','ID',173);
INSERT INTO TABLA_SINTAX VALUES ('resto_arg2u','ROWID',173);
INSERT INTO TABLA_SINTAX VALUES ('resto_arg2u','ROWNUM',173);
/* funciones */
INSERT INTO TABLA_SINTAX VALUES ('resto_arg2u','ABS',173);
INSERT INTO TABLA_SINTAX VALUES ('resto_arg2u','CDEG',173);
INSERT INTO TABLA_SINTAX VALUES ('resto_arg2u','CEIL',173);
INSERT INTO TABLA_SINTAX VALUES ('resto_arg2u','FLOOR',173);
INSERT INTO TABLA_SINTAX VALUES ('resto_arg2u','SIGN',173);
INSERT INTO TABLA_SINTAX VALUES ('resto_arg2u','SQRT',173);
INSERT INTO TABLA_SINTAX VALUES ('resto_arg2u','CHR',173);
INSERT INTO TABLA_SINTAX VALUES ('resto_arg2u','MOD',173);
INSERT INTO TABLA_SINTAX VALUES ('resto_arg2u','POWER',173);
INSERT INTO TABLA_SINTAX VALUES ('resto_arg2u','INITCAP',173);
INSERT INTO TABLA_SINTAX VALUES ('resto_arg2u','LOWER',173);
INSERT INTO TABLA_SINTAX VALUES ('resto_arg2u','LPAD',173);
INSERT INTO TABLA_SINTAX VALUES ('resto_arg2u','LTRIM',173);
INSERT INTO TABLA_SINTAX VALUES ('resto_arg2u','REPLACE',173);
INSERT INTO TABLA_SINTAX VALUES ('resto_arg2u','RPAD',173);
INSERT INTO TABLA_SINTAX VALUES ('resto_arg2u','RTRIM',173);
INSERT INTO TABLA_SINTAX VALUES ('resto_arg2u','SOUNDEX',173);
INSERT INTO TABLA_SINTAX VALUES ('resto_arg2u','SUBSTR',173);
INSERT INTO TABLA_SINTAX VALUES ('resto_arg2u','TRANSLATE',173);
INSERT INTO TABLA_SINTAX VALUES ('resto_arg2u','UPPER',173);
INSERT INTO TABLA_SINTAX VALUES ('resto_arg2u','ASCII',173);
INSERT INTO TABLA_SINTAX VALUES ('resto_arg2u','INSTR',173);
INSERT INTO TABLA_SINTAX VALUES ('resto_arg2u','LENGTH',173);
INSERT INTO TABLA_SINTAX VALUES ('resto_arg2u','NLSSORT',173);
INSERT INTO TABLA_SINTAX VALUES ('resto_arg2u','AVG',173);
INSERT INTO TABLA_SINTAX VALUES ('resto_arg2u','COUNT',173);
INSERT INTO TABLA_SINTAX VALUES ('resto_arg2u','MAX',173);
INSERT INTO TABLA_SINTAX VALUES ('resto_arg2u','MIN',173);
INSERT INTO TABLA_SINTAX VALUES ('resto_arg2u','STDDEV',173);
INSERT INTO TABLA_SINTAX VALUES ('resto_arg2u','SUM',173);
INSERT INTO TABLA_SINTAX VALUES ('resto_arg2u','VARIANCE',173);
INSERT INTO TABLA_SINTAX VALUES ('resto_arg2u','CHARTOROWID',173);
INSERT INTO TABLA_SINTAX VALUES ('resto_arg2u','CONVERT',173);
INSERT INTO TABLA_SINTAX VALUES ('resto_arg2u','HEXTORAW',173);
INSERT INTO TABLA_SINTAX VALUES ('resto_arg2u','RAWTOHEX',173);
INSERT INTO TABLA_SINTAX VALUES ('resto_arg2u','ROWIDTOCHAR',173);
INSERT INTO TABLA_SINTAX VALUES ('resto_arg2u','TO_CHAR',173);
INSERT INTO TABLA_SINTAX VALUES ('resto_arg2u','TO_DATE',173);
INSERT INTO TABLA_SINTAX VALUES ('resto_arg2u','TO_NUMBER',173);
INSERT INTO TABLA_SINTAX VALUES ('resto_arg2u','ADD_MONTHS',173);
INSERT INTO TABLA_SINTAX VALUES ('resto_arg2u','LAST_DAY',173);
INSERT INTO TABLA_SINTAX VALUES ('resto_arg2u','MONTHS_BETWEEN',173);
INSERT INTO TABLA_SINTAX VALUES ('resto_arg2u','NEW_TIME',173);
INSERT INTO TABLA_SINTAX VALUES ('resto_arg2u','NEXT_DAY',173);
INSERT INTO TABLA_SINTAX VALUES ('resto_arg2u','ROUND',173);
INSERT INTO TABLA_SINTAX VALUES ('resto_arg2u','TRUNC',173);
INSERT INTO TABLA_SINTAX VALUES ('resto_arg2u','DUMP',173);
INSERT INTO TABLA_SINTAX VALUES ('resto_arg2u','GREATEST',173);
INSERT INTO TABLA_SINTAX VALUES ('resto_arg2u','LEAST',173);
INSERT INTO TABLA_SINTAX VALUES ('resto_arg2u','NVL',173);
INSERT INTO TABLA_SINTAX VALUES ('resto_arg2u','USERENV',173);
INSERT INTO TABLA_SINTAX VALUES ('resto_arg2u','VSIZE',173);
INSERT INTO TABLA_SINTAX VALUES ('resto_arg2u','DECODE',173);
--174:      |   '*'
INSERT INTO PRODUCCIONES VALUES (174,1,'*','T');
INSERT INTO TABLA_SINTAX VALUES ('resto_arg2u','*',174);

--175: argu_deco    :   '(' expr ',' expr ',' expr mas_expres ')'
INSERT INTO PRODUCCIONES VALUES (175,1,'(','T');
INSERT INTO PRODUCCIONES VALUES (175,2,'expr','N');
INSERT INTO PRODUCCIONES VALUES (175,3,',','T');
INSERT INTO PRODUCCIONES VALUES (175,4,'expr','N');
INSERT INTO PRODUCCIONES VALUES (175,5,',','T');
INSERT INTO PRODUCCIONES VALUES (175,6,'expr','N');
INSERT INTO PRODUCCIONES VALUES (175,7,'mas_expres','N');
INSERT INTO PRODUCCIONES VALUES (175,8,')','T');
INSERT INTO TABLA_SINTAX VALUES ('argu_deco','(',175);

/*****> Definicin de la lista de tablas del FROM <*****/
--180: tablas:  ID resto_tab t_alias lista_tab
INSERT INTO PRODUCCIONES VALUES (180,1,'ID','T');
INSERT INTO PRODUCCIONES VALUES (180,2,'resto_tab','N');
INSERT INTO PRODUCCIONES VALUES (180,3,'t_alias','N');
INSERT INTO PRODUCCIONES VALUES (180,4,'lista_tab','N');
INSERT INTO TABLA_SINTAX VALUES ('tablas','ID',180);
--181:  |   '(' select_command ')' t_alias lista_tab
INSERT INTO PRODUCCIONES VALUES (181,1,'(','T');
INSERT INTO PRODUCCIONES VALUES (181,2,'select_command','N');
INSERT INTO PRODUCCIONES VALUES (181,3,')','T');
INSERT INTO PRODUCCIONES VALUES (181,4,'t_alias','N');
INSERT INTO PRODUCCIONES VALUES (181,5,'lista_tab','N');
INSERT INTO TABLA_SINTAX VALUES ('tablas','(',181);

--182: resto_tab:   '.' ID
INSERT INTO PRODUCCIONES VALUES (182,1,'.','T');
INSERT INTO PRODUCCIONES VALUES (182,2,'ID','T');
INSERT INTO TABLA_SINTAX VALUES ('resto_tab','.',182);
--183:  |
INSERT INTO PRODUCCIONES VALUES (183,1,'VACIO','N');
-- Seguidores(resto_tab)
INSERT INTO TABLA_SINTAX VALUES ('resto_tab',FIN,183);
INSERT INTO TABLA_SINTAX VALUES ('resto_tab',';',183);
INSERT INTO TABLA_SINTAX VALUES ('resto_tab','ID',183);
INSERT INTO TABLA_SINTAX VALUES ('resto_tab',',',183);
INSERT INTO TABLA_SINTAX VALUES ('resto_tab','WHERE',183);
INSERT INTO TABLA_SINTAX VALUES ('resto_tab','GROUP',183);
INSERT INTO TABLA_SINTAX VALUES ('resto_tab','START',183);
INSERT INTO TABLA_SINTAX VALUES ('resto_tab','CONNECT',183);
INSERT INTO TABLA_SINTAX VALUES ('resto_tab','UNION',183);
INSERT INTO TABLA_SINTAX VALUES ('resto_tab','INTERSECT',183);
INSERT INTO TABLA_SINTAX VALUES ('resto_tab','MINUS',183);
INSERT INTO TABLA_SINTAX VALUES ('resto_tab','ORDER',183);
INSERT INTO TABLA_SINTAX VALUES ('resto_tab',')',183);

--184: lista_tab:   ',' tablas
INSERT INTO PRODUCCIONES VALUES (184,1,',','T');
INSERT INTO PRODUCCIONES VALUES (184,2,'tablas','N');
INSERT INTO TABLA_SINTAX VALUES ('lista_tab',',',184);
--185:  |
INSERT INTO PRODUCCIONES VALUES (185,1,'VACIO','N');
-- Seguidores(lista_tab)=Seguidores(tablas)
INSERT INTO TABLA_SINTAX VALUES ('lista_tab',FIN,185);
INSERT INTO TABLA_SINTAX VALUES ('lista_tab',';',185);
INSERT INTO TABLA_SINTAX VALUES ('lista_tab','WHERE',185);
INSERT INTO TABLA_SINTAX VALUES ('lista_tab','GROUP',185);
INSERT INTO TABLA_SINTAX VALUES ('lista_tab','START',185);
INSERT INTO TABLA_SINTAX VALUES ('lista_tab','CONNECT',185);
INSERT INTO TABLA_SINTAX VALUES ('lista_tab','UNION',185);
INSERT INTO TABLA_SINTAX VALUES ('lista_tab','INTERSECT',185);
INSERT INTO TABLA_SINTAX VALUES ('lista_tab','MINUS',185);
INSERT INTO TABLA_SINTAX VALUES ('lista_tab','ORDER',185);
INSERT INTO TABLA_SINTAX VALUES ('lista_tab',')',185);

--186:t_alias:  ID
INSERT INTO PRODUCCIONES VALUES (186,1,'ID','T');
INSERT INTO TABLA_SINTAX VALUES ('t_alias','ID',186);
--187:  |
INSERT INTO PRODUCCIONES VALUES (187,1,'VACIO','N');
-- Seguidores(t_alias)= ',' U Seguidores(tablas)
INSERT INTO TABLA_SINTAX VALUES ('t_alias',',',187);
INSERT INTO TABLA_SINTAX VALUES ('t_alias',FIN,187);
INSERT INTO TABLA_SINTAX VALUES ('t_alias',';',187);
INSERT INTO TABLA_SINTAX VALUES ('t_alias','WHERE',187);
INSERT INTO TABLA_SINTAX VALUES ('t_alias','GROUP',187);
INSERT INTO TABLA_SINTAX VALUES ('t_alias','START',187);
INSERT INTO TABLA_SINTAX VALUES ('t_alias','CONNECT',187);
INSERT INTO TABLA_SINTAX VALUES ('t_alias','UNION',187);
INSERT INTO TABLA_SINTAX VALUES ('t_alias','INTERSECT',187);
INSERT INTO TABLA_SINTAX VALUES ('t_alias','MINUS',187);
INSERT INTO TABLA_SINTAX VALUES ('t_alias','ORDER',187);
INSERT INTO TABLA_SINTAX VALUES ('t_alias',')',187);
END;
/

DECLARE -- Bloque 3
  FIN CONSTANT PRODUCCIONES.parte_der%TYPE := 'THE END';
BEGIN
dbms_output.put_line('>>>> Tablas PRODUCCIONES y TABLA_SINTAX: Insertando valores... Bloque 3/3');

/*****> Definicin de la clusula WHERE: condiciones <*****/
--190: clausula_where:  WHERE condition
INSERT INTO PRODUCCIONES VALUES (190,1,'WHERE','T');
INSERT INTO PRODUCCIONES VALUES (190,2,'condition','N');
INSERT INTO TABLA_SINTAX VALUES ('clausula_where','WHERE',190);
--191:  |
INSERT INTO PRODUCCIONES VALUES (191,1,'VACIO','N');
-- Seguidores(clausula_where)
INSERT INTO TABLA_SINTAX VALUES ('clausula_where',FIN,191);
INSERT INTO TABLA_SINTAX VALUES ('clausula_where',';',191);
INSERT INTO TABLA_SINTAX VALUES ('clausula_where','GROUP',191);
INSERT INTO TABLA_SINTAX VALUES ('clausula_where','START',191);
INSERT INTO TABLA_SINTAX VALUES ('clausula_where','CONNECT',191);
INSERT INTO TABLA_SINTAX VALUES ('clausula_where','UNION',191);
INSERT INTO TABLA_SINTAX VALUES ('clausula_where','INTERSECT',191);
INSERT INTO TABLA_SINTAX VALUES ('clausula_where','MINUS',191);
INSERT INTO TABLA_SINTAX VALUES ('clausula_where','ORDER',191);
INSERT INTO TABLA_SINTAX VALUES ('clausula_where',')',191);

--192: condition:   cond_AND resto_cond
INSERT INTO PRODUCCIONES VALUES (192,1,'cond_AND','N');
INSERT INTO PRODUCCIONES VALUES (192,2,'resto_cond','N');
-- Iniciales(cond_AND)=Iniciales(condition)=NOT,$,#,[,EXISTS,Iniciales(expr)
INSERT INTO TABLA_SINTAX VALUES ('condition','NOT',192);
INSERT INTO TABLA_SINTAX VALUES ('condition','$',192);
INSERT INTO TABLA_SINTAX VALUES ('condition','#',192);
INSERT INTO TABLA_SINTAX VALUES ('condition','[',192);
INSERT INTO TABLA_SINTAX VALUES ('condition','+',192);
INSERT INTO TABLA_SINTAX VALUES ('condition','-',192);
INSERT INTO TABLA_SINTAX VALUES ('condition','PRIOR',192);
INSERT INTO TABLA_SINTAX VALUES ('condition','(',192);
INSERT INTO TABLA_SINTAX VALUES ('condition','{',192);
INSERT INTO TABLA_SINTAX VALUES ('condition','EXISTS',192);
/* ctes */
INSERT INTO TABLA_SINTAX VALUES ('condition','NUMERO',192);
INSERT INTO TABLA_SINTAX VALUES ('condition','SYSDATE',192);
INSERT INTO TABLA_SINTAX VALUES ('condition','UID',192);
INSERT INTO TABLA_SINTAX VALUES ('condition','USER',192);
INSERT INTO TABLA_SINTAX VALUES ('condition','TEXTO',192);
INSERT INTO TABLA_SINTAX VALUES ('condition','LEVEL',192);
INSERT INTO TABLA_SINTAX VALUES ('condition','NULL',192);
INSERT INTO TABLA_SINTAX VALUES ('condition','UNDEFINED',192);
INSERT INTO TABLA_SINTAX VALUES ('condition','UNKNOWN',192);
/* columna */
INSERT INTO TABLA_SINTAX VALUES ('condition','ID',192);
INSERT INTO TABLA_SINTAX VALUES ('condition','ROWID',192);
INSERT INTO TABLA_SINTAX VALUES ('condition','ROWNUM',192);
/* funciones */
INSERT INTO TABLA_SINTAX VALUES ('condition','ABS',192);
INSERT INTO TABLA_SINTAX VALUES ('condition','CDEG',192);
INSERT INTO TABLA_SINTAX VALUES ('condition','CEIL',192);
INSERT INTO TABLA_SINTAX VALUES ('condition','FLOOR',192);
INSERT INTO TABLA_SINTAX VALUES ('condition','SIGN',192);
INSERT INTO TABLA_SINTAX VALUES ('condition','SQRT',192);
INSERT INTO TABLA_SINTAX VALUES ('condition','CHR',192);
INSERT INTO TABLA_SINTAX VALUES ('condition','MOD',192);
INSERT INTO TABLA_SINTAX VALUES ('condition','POWER',192);
INSERT INTO TABLA_SINTAX VALUES ('condition','INITCAP',192);
INSERT INTO TABLA_SINTAX VALUES ('condition','LOWER',192);
INSERT INTO TABLA_SINTAX VALUES ('condition','LPAD',192);
INSERT INTO TABLA_SINTAX VALUES ('condition','LTRIM',192);
INSERT INTO TABLA_SINTAX VALUES ('condition','REPLACE',192);
INSERT INTO TABLA_SINTAX VALUES ('condition','RPAD',192);
INSERT INTO TABLA_SINTAX VALUES ('condition','RTRIM',192);
INSERT INTO TABLA_SINTAX VALUES ('condition','SOUNDEX',192);
INSERT INTO TABLA_SINTAX VALUES ('condition','SUBSTR',192);
INSERT INTO TABLA_SINTAX VALUES ('condition','TRANSLATE',192);
INSERT INTO TABLA_SINTAX VALUES ('condition','UPPER',192);
INSERT INTO TABLA_SINTAX VALUES ('condition','ASCII',192);
INSERT INTO TABLA_SINTAX VALUES ('condition','INSTR',192);
INSERT INTO TABLA_SINTAX VALUES ('condition','LENGTH',192);
INSERT INTO TABLA_SINTAX VALUES ('condition','NLSSORT',192);
INSERT INTO TABLA_SINTAX VALUES ('condition','AVG',192);
INSERT INTO TABLA_SINTAX VALUES ('condition','COUNT',192);
INSERT INTO TABLA_SINTAX VALUES ('condition','MAX',192);
INSERT INTO TABLA_SINTAX VALUES ('condition','MIN',192);
INSERT INTO TABLA_SINTAX VALUES ('condition','STDDEV',192);
INSERT INTO TABLA_SINTAX VALUES ('condition','SUM',192);
INSERT INTO TABLA_SINTAX VALUES ('condition','VARIANCE',192);
INSERT INTO TABLA_SINTAX VALUES ('condition','CHARTOROWID',192);
INSERT INTO TABLA_SINTAX VALUES ('condition','CONVERT',192);
INSERT INTO TABLA_SINTAX VALUES ('condition','HEXTORAW',192);
INSERT INTO TABLA_SINTAX VALUES ('condition','RAWTOHEX',192);
INSERT INTO TABLA_SINTAX VALUES ('condition','ROWIDTOCHAR',192);
INSERT INTO TABLA_SINTAX VALUES ('condition','TO_CHAR',192);
INSERT INTO TABLA_SINTAX VALUES ('condition','TO_DATE',192);
INSERT INTO TABLA_SINTAX VALUES ('condition','TO_NUMBER',192);
INSERT INTO TABLA_SINTAX VALUES ('condition','ADD_MONTHS',192);
INSERT INTO TABLA_SINTAX VALUES ('condition','LAST_DAY',192);
INSERT INTO TABLA_SINTAX VALUES ('condition','MONTHS_BETWEEN',192);
INSERT INTO TABLA_SINTAX VALUES ('condition','NEW_TIME',192);
INSERT INTO TABLA_SINTAX VALUES ('condition','NEXT_DAY',192);
INSERT INTO TABLA_SINTAX VALUES ('condition','ROUND',192);
INSERT INTO TABLA_SINTAX VALUES ('condition','TRUNC',192);
INSERT INTO TABLA_SINTAX VALUES ('condition','DUMP',192);
INSERT INTO TABLA_SINTAX VALUES ('condition','GREATEST',192);
INSERT INTO TABLA_SINTAX VALUES ('condition','LEAST',192);
INSERT INTO TABLA_SINTAX VALUES ('condition','NVL',192);
INSERT INTO TABLA_SINTAX VALUES ('condition','USERENV',192);
INSERT INTO TABLA_SINTAX VALUES ('condition','VSIZE',192);
INSERT INTO TABLA_SINTAX VALUES ('condition','DECODE',192);

--193:cond_AND: cond_NOT resto_AND
INSERT INTO PRODUCCIONES VALUES (193,1,'cond_NOT','N');
INSERT INTO PRODUCCIONES VALUES (193,2,'resto_AND','N');
-- Iniciales(cond_NOT)=Iniciales(cond_AND)
INSERT INTO TABLA_SINTAX VALUES ('cond_AND','NOT',193);
INSERT INTO TABLA_SINTAX VALUES ('cond_AND','$',193);
INSERT INTO TABLA_SINTAX VALUES ('cond_AND','#',193);
INSERT INTO TABLA_SINTAX VALUES ('cond_AND','[',193);
INSERT INTO TABLA_SINTAX VALUES ('cond_AND','+',193);
INSERT INTO TABLA_SINTAX VALUES ('cond_AND','-',193);
INSERT INTO TABLA_SINTAX VALUES ('cond_AND','PRIOR',193);
INSERT INTO TABLA_SINTAX VALUES ('cond_AND','(',193);
INSERT INTO TABLA_SINTAX VALUES ('cond_AND','{',193);
INSERT INTO TABLA_SINTAX VALUES ('cond_AND','EXISTS',193);
/* ctes */
INSERT INTO TABLA_SINTAX VALUES ('cond_AND','NUMERO',193);
INSERT INTO TABLA_SINTAX VALUES ('cond_AND','SYSDATE',193);
INSERT INTO TABLA_SINTAX VALUES ('cond_AND','UID',193);
INSERT INTO TABLA_SINTAX VALUES ('cond_AND','USER',193);
INSERT INTO TABLA_SINTAX VALUES ('cond_AND','TEXTO',193);
INSERT INTO TABLA_SINTAX VALUES ('cond_AND','LEVEL',193);
INSERT INTO TABLA_SINTAX VALUES ('cond_AND','NULL',193);
INSERT INTO TABLA_SINTAX VALUES ('cond_AND','UNDEFINED',193);
INSERT INTO TABLA_SINTAX VALUES ('cond_AND','UNKNOWN',193);
/* columna */
INSERT INTO TABLA_SINTAX VALUES ('cond_AND','ID',193);
INSERT INTO TABLA_SINTAX VALUES ('cond_AND','ROWID',193);
INSERT INTO TABLA_SINTAX VALUES ('cond_AND','ROWNUM',193);
/* funciones */
INSERT INTO TABLA_SINTAX VALUES ('cond_AND','ABS',193);
INSERT INTO TABLA_SINTAX VALUES ('cond_AND','CDEG',193);
INSERT INTO TABLA_SINTAX VALUES ('cond_AND','CEIL',193);
INSERT INTO TABLA_SINTAX VALUES ('cond_AND','FLOOR',193);
INSERT INTO TABLA_SINTAX VALUES ('cond_AND','SIGN',193);
INSERT INTO TABLA_SINTAX VALUES ('cond_AND','SQRT',193);
INSERT INTO TABLA_SINTAX VALUES ('cond_AND','CHR',193);
INSERT INTO TABLA_SINTAX VALUES ('cond_AND','MOD',193);
INSERT INTO TABLA_SINTAX VALUES ('cond_AND','POWER',193);
INSERT INTO TABLA_SINTAX VALUES ('cond_AND','INITCAP',193);
INSERT INTO TABLA_SINTAX VALUES ('cond_AND','LOWER',193);
INSERT INTO TABLA_SINTAX VALUES ('cond_AND','LPAD',193);
INSERT INTO TABLA_SINTAX VALUES ('cond_AND','LTRIM',193);
INSERT INTO TABLA_SINTAX VALUES ('cond_AND','REPLACE',193);
INSERT INTO TABLA_SINTAX VALUES ('cond_AND','RPAD',193);
INSERT INTO TABLA_SINTAX VALUES ('cond_AND','RTRIM',193);
INSERT INTO TABLA_SINTAX VALUES ('cond_AND','SOUNDEX',193);
INSERT INTO TABLA_SINTAX VALUES ('cond_AND','SUBSTR',193);
INSERT INTO TABLA_SINTAX VALUES ('cond_AND','TRANSLATE',193);
INSERT INTO TABLA_SINTAX VALUES ('cond_AND','UPPER',193);
INSERT INTO TABLA_SINTAX VALUES ('cond_AND','ASCII',193);
INSERT INTO TABLA_SINTAX VALUES ('cond_AND','INSTR',193);
INSERT INTO TABLA_SINTAX VALUES ('cond_AND','LENGTH',193);
INSERT INTO TABLA_SINTAX VALUES ('cond_AND','NLSSORT',193);
INSERT INTO TABLA_SINTAX VALUES ('cond_AND','AVG',193);
INSERT INTO TABLA_SINTAX VALUES ('cond_AND','COUNT',193);
INSERT INTO TABLA_SINTAX VALUES ('cond_AND','MAX',193);
INSERT INTO TABLA_SINTAX VALUES ('cond_AND','MIN',193);
INSERT INTO TABLA_SINTAX VALUES ('cond_AND','STDDEV',193);
INSERT INTO TABLA_SINTAX VALUES ('cond_AND','SUM',193);
INSERT INTO TABLA_SINTAX VALUES ('cond_AND','VARIANCE',193);
INSERT INTO TABLA_SINTAX VALUES ('cond_AND','CHARTOROWID',193);
INSERT INTO TABLA_SINTAX VALUES ('cond_AND','CONVERT',193);
INSERT INTO TABLA_SINTAX VALUES ('cond_AND','HEXTORAW',193);
INSERT INTO TABLA_SINTAX VALUES ('cond_AND','RAWTOHEX',193);
INSERT INTO TABLA_SINTAX VALUES ('cond_AND','ROWIDTOCHAR',193);
INSERT INTO TABLA_SINTAX VALUES ('cond_AND','TO_CHAR',193);
INSERT INTO TABLA_SINTAX VALUES ('cond_AND','TO_DATE',193);
INSERT INTO TABLA_SINTAX VALUES ('cond_AND','TO_NUMBER',193);
INSERT INTO TABLA_SINTAX VALUES ('cond_AND','ADD_MONTHS',193);
INSERT INTO TABLA_SINTAX VALUES ('cond_AND','LAST_DAY',193);
INSERT INTO TABLA_SINTAX VALUES ('cond_AND','MONTHS_BETWEEN',193);
INSERT INTO TABLA_SINTAX VALUES ('cond_AND','NEW_TIME',193);
INSERT INTO TABLA_SINTAX VALUES ('cond_AND','NEXT_DAY',193);
INSERT INTO TABLA_SINTAX VALUES ('cond_AND','ROUND',193);
INSERT INTO TABLA_SINTAX VALUES ('cond_AND','TRUNC',193);
INSERT INTO TABLA_SINTAX VALUES ('cond_AND','DUMP',193);
INSERT INTO TABLA_SINTAX VALUES ('cond_AND','GREATEST',193);
INSERT INTO TABLA_SINTAX VALUES ('cond_AND','LEAST',193);
INSERT INTO TABLA_SINTAX VALUES ('cond_AND','NVL',193);
INSERT INTO TABLA_SINTAX VALUES ('cond_AND','USERENV',193);
INSERT INTO TABLA_SINTAX VALUES ('cond_AND','VSIZE',193);
INSERT INTO TABLA_SINTAX VALUES ('cond_AND','DECODE',193);

--194: resto_cond:  OR condition
INSERT INTO PRODUCCIONES VALUES (194,1,'OR','T');
INSERT INTO PRODUCCIONES VALUES (194,2,'condition','N');
INSERT INTO TABLA_SINTAX VALUES ('resto_cond','OR',194);
--195:  |
INSERT INTO PRODUCCIONES VALUES (195,1,'VACIO','N');
-- Seguidores(resto_cond)=Seguidores(condition)
INSERT INTO TABLA_SINTAX VALUES ('resto_cond',FIN,195);
INSERT INTO TABLA_SINTAX VALUES ('resto_cond',';',195);
INSERT INTO TABLA_SINTAX VALUES ('resto_cond',')',195);
INSERT INTO TABLA_SINTAX VALUES ('resto_cond','}',195);
INSERT INTO TABLA_SINTAX VALUES ('resto_cond','GROUP',195);
INSERT INTO TABLA_SINTAX VALUES ('resto_cond','CONNECT',195);
INSERT INTO TABLA_SINTAX VALUES ('resto_cond','START',195);
INSERT INTO TABLA_SINTAX VALUES ('resto_cond','UNION',195);
INSERT INTO TABLA_SINTAX VALUES ('resto_cond','INTERSECT',195);
INSERT INTO TABLA_SINTAX VALUES ('resto_cond','MINUS',195);
INSERT INTO TABLA_SINTAX VALUES ('resto_cond','ORDER',195);

--196: cond_NOT:    NOT cond_NOT
INSERT INTO PRODUCCIONES VALUES (196,1,'NOT','T');
INSERT INTO PRODUCCIONES VALUES (196,2,'cond_NOT','N');
INSERT INTO TABLA_SINTAX VALUES ('cond_NOT','NOT',196);
--197:  |   cond_elemental
INSERT INTO PRODUCCIONES VALUES (197,1,'cond_elemental','N');
INSERT INTO TABLA_SINTAX VALUES ('cond_NOT','$',197);
INSERT INTO TABLA_SINTAX VALUES ('cond_NOT','#',197);
INSERT INTO TABLA_SINTAX VALUES ('cond_NOT','[',197);
INSERT INTO TABLA_SINTAX VALUES ('cond_NOT','+',197);
INSERT INTO TABLA_SINTAX VALUES ('cond_NOT','-',197);
INSERT INTO TABLA_SINTAX VALUES ('cond_NOT','PRIOR',197);
INSERT INTO TABLA_SINTAX VALUES ('cond_NOT','(',197);
INSERT INTO TABLA_SINTAX VALUES ('cond_NOT','{',197);
INSERT INTO TABLA_SINTAX VALUES ('cond_NOT','NUMERO',197);
INSERT INTO TABLA_SINTAX VALUES ('cond_NOT','SYSDATE',197);
INSERT INTO TABLA_SINTAX VALUES ('cond_NOT','UID',197);
INSERT INTO TABLA_SINTAX VALUES ('cond_NOT','USER',197);
INSERT INTO TABLA_SINTAX VALUES ('cond_NOT','TEXTO',197);
INSERT INTO TABLA_SINTAX VALUES ('cond_NOT','LEVEL',197);
INSERT INTO TABLA_SINTAX VALUES ('cond_NOT','NULL',197);
INSERT INTO TABLA_SINTAX VALUES ('cond_NOT','UNDEFINED',197);
INSERT INTO TABLA_SINTAX VALUES ('cond_NOT','UNKNOWN',197);
INSERT INTO TABLA_SINTAX VALUES ('cond_NOT','ID',197);
INSERT INTO TABLA_SINTAX VALUES ('cond_NOT','ROWID',197);
INSERT INTO TABLA_SINTAX VALUES ('cond_NOT','ROWNUM',197);
INSERT INTO TABLA_SINTAX VALUES ('cond_NOT','ABS',197);
INSERT INTO TABLA_SINTAX VALUES ('cond_NOT','CDEG',197);
INSERT INTO TABLA_SINTAX VALUES ('cond_NOT','CEIL',197);
INSERT INTO TABLA_SINTAX VALUES ('cond_NOT','FLOOR',197);
INSERT INTO TABLA_SINTAX VALUES ('cond_NOT','SIGN',197);
INSERT INTO TABLA_SINTAX VALUES ('cond_NOT','SQRT',197);
INSERT INTO TABLA_SINTAX VALUES ('cond_NOT','CHR',197);
INSERT INTO TABLA_SINTAX VALUES ('cond_NOT','MOD',197);
INSERT INTO TABLA_SINTAX VALUES ('cond_NOT','POWER',197);
INSERT INTO TABLA_SINTAX VALUES ('cond_NOT','INITCAP',197);
INSERT INTO TABLA_SINTAX VALUES ('cond_NOT','LOWER',197);
INSERT INTO TABLA_SINTAX VALUES ('cond_NOT','LPAD',197);
INSERT INTO TABLA_SINTAX VALUES ('cond_NOT','LTRIM',197);
INSERT INTO TABLA_SINTAX VALUES ('cond_NOT','REPLACE',197);
INSERT INTO TABLA_SINTAX VALUES ('cond_NOT','RPAD',197);
INSERT INTO TABLA_SINTAX VALUES ('cond_NOT','RTRIM',197);
INSERT INTO TABLA_SINTAX VALUES ('cond_NOT','SOUNDEX',197);
INSERT INTO TABLA_SINTAX VALUES ('cond_NOT','SUBSTR',197);
INSERT INTO TABLA_SINTAX VALUES ('cond_NOT','TRANSLATE',197);
INSERT INTO TABLA_SINTAX VALUES ('cond_NOT','UPPER',197);
INSERT INTO TABLA_SINTAX VALUES ('cond_NOT','ASCII',197);
INSERT INTO TABLA_SINTAX VALUES ('cond_NOT','INSTR',197);
INSERT INTO TABLA_SINTAX VALUES ('cond_NOT','LENGTH',197);
INSERT INTO TABLA_SINTAX VALUES ('cond_NOT','NLSSORT',197);
INSERT INTO TABLA_SINTAX VALUES ('cond_NOT','AVG',197);
INSERT INTO TABLA_SINTAX VALUES ('cond_NOT','COUNT',197);
INSERT INTO TABLA_SINTAX VALUES ('cond_NOT','MAX',197);
INSERT INTO TABLA_SINTAX VALUES ('cond_NOT','MIN',197);
INSERT INTO TABLA_SINTAX VALUES ('cond_NOT','STDDEV',197);
INSERT INTO TABLA_SINTAX VALUES ('cond_NOT','SUM',197);
INSERT INTO TABLA_SINTAX VALUES ('cond_NOT','VARIANCE',197);
INSERT INTO TABLA_SINTAX VALUES ('cond_NOT','CHARTOROWID',197);
INSERT INTO TABLA_SINTAX VALUES ('cond_NOT','CONVERT',197);
INSERT INTO TABLA_SINTAX VALUES ('cond_NOT','HEXTORAW',197);
INSERT INTO TABLA_SINTAX VALUES ('cond_NOT','RAWTOHEX',197);
INSERT INTO TABLA_SINTAX VALUES ('cond_NOT','ROWIDTOCHAR',197);
INSERT INTO TABLA_SINTAX VALUES ('cond_NOT','TO_CHAR',197);
INSERT INTO TABLA_SINTAX VALUES ('cond_NOT','TO_DATE',197);
INSERT INTO TABLA_SINTAX VALUES ('cond_NOT','TO_NUMBER',197);
INSERT INTO TABLA_SINTAX VALUES ('cond_NOT','ADD_MONTHS',197);
INSERT INTO TABLA_SINTAX VALUES ('cond_NOT','LAST_DAY',197);
INSERT INTO TABLA_SINTAX VALUES ('cond_NOT','MONTHS_BETWEEN',197);
INSERT INTO TABLA_SINTAX VALUES ('cond_NOT','NEW_TIME',197);
INSERT INTO TABLA_SINTAX VALUES ('cond_NOT','NEXT_DAY',197);
INSERT INTO TABLA_SINTAX VALUES ('cond_NOT','ROUND',197);
INSERT INTO TABLA_SINTAX VALUES ('cond_NOT','TRUNC',197);
INSERT INTO TABLA_SINTAX VALUES ('cond_NOT','DUMP',197);
INSERT INTO TABLA_SINTAX VALUES ('cond_NOT','GREATEST',197);
INSERT INTO TABLA_SINTAX VALUES ('cond_NOT','LEAST',197);
INSERT INTO TABLA_SINTAX VALUES ('cond_NOT','NVL',197);
INSERT INTO TABLA_SINTAX VALUES ('cond_NOT','USERENV',197);
INSERT INTO TABLA_SINTAX VALUES ('cond_NOT','VSIZE',197);
INSERT INTO TABLA_SINTAX VALUES ('cond_NOT','DECODE',197);
INSERT INTO TABLA_SINTAX VALUES ('cond_NOT','EXISTS',197);

--198: resto_AND:   AND cond_AND
INSERT INTO PRODUCCIONES VALUES (198,1,'AND','T');
INSERT INTO PRODUCCIONES VALUES (198,2,'cond_AND','N');
INSERT INTO TABLA_SINTAX VALUES ('resto_AND','AND',198);
--199:  |
INSERT INTO PRODUCCIONES VALUES (199,1,'VACIO','N');
INSERT INTO TABLA_SINTAX VALUES ('resto_AND',FIN,199);
INSERT INTO TABLA_SINTAX VALUES ('resto_AND',';',199);
INSERT INTO TABLA_SINTAX VALUES ('resto_AND',')',199);
INSERT INTO TABLA_SINTAX VALUES ('resto_AND','}',199);
INSERT INTO TABLA_SINTAX VALUES ('resto_AND','OR',199);
INSERT INTO TABLA_SINTAX VALUES ('resto_AND','GROUP',199);
INSERT INTO TABLA_SINTAX VALUES ('resto_AND','CONNECT',199);
INSERT INTO TABLA_SINTAX VALUES ('resto_AND','START',199);
INSERT INTO TABLA_SINTAX VALUES ('resto_AND','UNION',199);
INSERT INTO TABLA_SINTAX VALUES ('resto_AND','INTERSECT',199);
INSERT INTO TABLA_SINTAX VALUES ('resto_AND','MINUS',199);
INSERT INTO TABLA_SINTAX VALUES ('resto_AND','ORDER',199);

--210: cond_elemental:  expr resto_cond_elemental
INSERT INTO PRODUCCIONES VALUES (210,1,'expr','N');
INSERT INTO PRODUCCIONES VALUES (210,2,'resto_cond_elemental','N');
-- Iniciales(expr)
INSERT INTO TABLA_SINTAX VALUES ('cond_elemental','+',210);
INSERT INTO TABLA_SINTAX VALUES ('cond_elemental','-',210);
INSERT INTO TABLA_SINTAX VALUES ('cond_elemental','PRIOR',210);
INSERT INTO TABLA_SINTAX VALUES ('cond_elemental','(',210);
INSERT INTO TABLA_SINTAX VALUES ('cond_elemental','{',210);
/* ctes */
INSERT INTO TABLA_SINTAX VALUES ('cond_elemental','NUMERO',210);
INSERT INTO TABLA_SINTAX VALUES ('cond_elemental','SYSDATE',210);
INSERT INTO TABLA_SINTAX VALUES ('cond_elemental','UID',210);
INSERT INTO TABLA_SINTAX VALUES ('cond_elemental','USER',210);
INSERT INTO TABLA_SINTAX VALUES ('cond_elemental','TEXTO',210);
INSERT INTO TABLA_SINTAX VALUES ('cond_elemental','LEVEL',210);
INSERT INTO TABLA_SINTAX VALUES ('cond_elemental','NULL',210);
INSERT INTO TABLA_SINTAX VALUES ('cond_elemental','UNDEFINED',210);
INSERT INTO TABLA_SINTAX VALUES ('cond_elemental','UNKNOWN',210);
/* columna */
INSERT INTO TABLA_SINTAX VALUES ('cond_elemental','ID',210);
INSERT INTO TABLA_SINTAX VALUES ('cond_elemental','ROWID',210);
INSERT INTO TABLA_SINTAX VALUES ('cond_elemental','ROWNUM',210);
/* funciones */
INSERT INTO TABLA_SINTAX VALUES ('cond_elemental','ABS',210);
INSERT INTO TABLA_SINTAX VALUES ('cond_elemental','CDEG',210);
INSERT INTO TABLA_SINTAX VALUES ('cond_elemental','CEIL',210);
INSERT INTO TABLA_SINTAX VALUES ('cond_elemental','FLOOR',210);
INSERT INTO TABLA_SINTAX VALUES ('cond_elemental','SIGN',210);
INSERT INTO TABLA_SINTAX VALUES ('cond_elemental','SQRT',210);
INSERT INTO TABLA_SINTAX VALUES ('cond_elemental','CHR',210);
INSERT INTO TABLA_SINTAX VALUES ('cond_elemental','MOD',210);
INSERT INTO TABLA_SINTAX VALUES ('cond_elemental','POWER',210);
INSERT INTO TABLA_SINTAX VALUES ('cond_elemental','INITCAP',210);
INSERT INTO TABLA_SINTAX VALUES ('cond_elemental','LOWER',210);
INSERT INTO TABLA_SINTAX VALUES ('cond_elemental','LPAD',210);
INSERT INTO TABLA_SINTAX VALUES ('cond_elemental','LTRIM',210);
INSERT INTO TABLA_SINTAX VALUES ('cond_elemental','REPLACE',210);
INSERT INTO TABLA_SINTAX VALUES ('cond_elemental','RPAD',210);
INSERT INTO TABLA_SINTAX VALUES ('cond_elemental','RTRIM',210);
INSERT INTO TABLA_SINTAX VALUES ('cond_elemental','SOUNDEX',210);
INSERT INTO TABLA_SINTAX VALUES ('cond_elemental','SUBSTR',210);
INSERT INTO TABLA_SINTAX VALUES ('cond_elemental','TRANSLATE',210);
INSERT INTO TABLA_SINTAX VALUES ('cond_elemental','UPPER',210);
INSERT INTO TABLA_SINTAX VALUES ('cond_elemental','ASCII',210);
INSERT INTO TABLA_SINTAX VALUES ('cond_elemental','INSTR',210);
INSERT INTO TABLA_SINTAX VALUES ('cond_elemental','LENGTH',210);
INSERT INTO TABLA_SINTAX VALUES ('cond_elemental','NLSSORT',210);
INSERT INTO TABLA_SINTAX VALUES ('cond_elemental','AVG',210);
INSERT INTO TABLA_SINTAX VALUES ('cond_elemental','COUNT',210);
INSERT INTO TABLA_SINTAX VALUES ('cond_elemental','MAX',210);
INSERT INTO TABLA_SINTAX VALUES ('cond_elemental','MIN',210);
INSERT INTO TABLA_SINTAX VALUES ('cond_elemental','STDDEV',210);
INSERT INTO TABLA_SINTAX VALUES ('cond_elemental','SUM',210);
INSERT INTO TABLA_SINTAX VALUES ('cond_elemental','VARIANCE',210);
INSERT INTO TABLA_SINTAX VALUES ('cond_elemental','CHARTOROWID',210);
INSERT INTO TABLA_SINTAX VALUES ('cond_elemental','CONVERT',210);
INSERT INTO TABLA_SINTAX VALUES ('cond_elemental','HEXTORAW',210);
INSERT INTO TABLA_SINTAX VALUES ('cond_elemental','RAWTOHEX',210);
INSERT INTO TABLA_SINTAX VALUES ('cond_elemental','ROWIDTOCHAR',210);
INSERT INTO TABLA_SINTAX VALUES ('cond_elemental','TO_CHAR',210);
INSERT INTO TABLA_SINTAX VALUES ('cond_elemental','TO_DATE',210);
INSERT INTO TABLA_SINTAX VALUES ('cond_elemental','TO_NUMBER',210);
INSERT INTO TABLA_SINTAX VALUES ('cond_elemental','ADD_MONTHS',210);
INSERT INTO TABLA_SINTAX VALUES ('cond_elemental','LAST_DAY',210);
INSERT INTO TABLA_SINTAX VALUES ('cond_elemental','MONTHS_BETWEEN',210);
INSERT INTO TABLA_SINTAX VALUES ('cond_elemental','NEW_TIME',210);
INSERT INTO TABLA_SINTAX VALUES ('cond_elemental','NEXT_DAY',210);
INSERT INTO TABLA_SINTAX VALUES ('cond_elemental','ROUND',210);
INSERT INTO TABLA_SINTAX VALUES ('cond_elemental','TRUNC',210);
INSERT INTO TABLA_SINTAX VALUES ('cond_elemental','DUMP',210);
INSERT INTO TABLA_SINTAX VALUES ('cond_elemental','GREATEST',210);
INSERT INTO TABLA_SINTAX VALUES ('cond_elemental','LEAST',210);
INSERT INTO TABLA_SINTAX VALUES ('cond_elemental','NVL',210);
INSERT INTO TABLA_SINTAX VALUES ('cond_elemental','USERENV',210);
INSERT INTO TABLA_SINTAX VALUES ('cond_elemental','VSIZE',210);
INSERT INTO TABLA_SINTAX VALUES ('cond_elemental','DECODE',210);

--211:      |   '$' resto_fexpr           resto_fcond
INSERT INTO PRODUCCIONES VALUES (211,1,'$','T');
INSERT INTO PRODUCCIONES VALUES (211,2,'resto_fexpr','N');
INSERT INTO PRODUCCIONES VALUES (211,3,'resto_fcond','N');
INSERT INTO TABLA_SINTAX VALUES ('cond_elemental','$',211);
--212:      |   '#' NUMERO                resto_fcond
INSERT INTO PRODUCCIONES VALUES (212,1,'#','T');
INSERT INTO PRODUCCIONES VALUES (212,2,'NUMERO','T');
INSERT INTO PRODUCCIONES VALUES (212,3,'resto_fcond','N');
INSERT INTO TABLA_SINTAX VALUES ('cond_elemental','#',212);
--213:      |   '[' NUMERO ',' NUMERO ']' resto_fcond
INSERT INTO PRODUCCIONES VALUES (213,1,'[','T');
INSERT INTO PRODUCCIONES VALUES (213,2,'NUMERO','T');
INSERT INTO PRODUCCIONES VALUES (213,3,',','T');
INSERT INTO PRODUCCIONES VALUES (213,4,'NUMERO','T');
INSERT INTO PRODUCCIONES VALUES (213,5,']','T');
INSERT INTO PRODUCCIONES VALUES (213,6,'resto_fcond','N');
INSERT INTO TABLA_SINTAX VALUES ('cond_elemental','[',213);
--500:      |   EXISTS '(' select_command ')' /* Produccin n 500 */
INSERT INTO PRODUCCIONES VALUES (500,1,'EXISTS','T');
INSERT INTO PRODUCCIONES VALUES (500,2,'(','T');
INSERT INTO PRODUCCIONES VALUES (500,3,'select_command','N');
INSERT INTO PRODUCCIONES VALUES (500,4,')','T');
INSERT INTO TABLA_SINTAX VALUES ('cond_elemental','EXISTS',500);

--214: resto_cond_elemental:    resto_nofcond
INSERT INTO PRODUCCIONES VALUES (214,1,'resto_nofcond','N');
INSERT INTO TABLA_SINTAX VALUES ('resto_cond_elemental','NOT',214);
INSERT INTO TABLA_SINTAX VALUES ('resto_cond_elemental','EQ',214);
INSERT INTO TABLA_SINTAX VALUES ('resto_cond_elemental','NEQ',214);
INSERT INTO TABLA_SINTAX VALUES ('resto_cond_elemental','LEQ',214);
INSERT INTO TABLA_SINTAX VALUES ('resto_cond_elemental','GEQ',214);
INSERT INTO TABLA_SINTAX VALUES ('resto_cond_elemental','LT',214);
INSERT INTO TABLA_SINTAX VALUES ('resto_cond_elemental','GT',214);
INSERT INTO TABLA_SINTAX VALUES ('resto_cond_elemental','BETWEEN',214);
INSERT INTO TABLA_SINTAX VALUES ('resto_cond_elemental','IN',214);
INSERT INTO TABLA_SINTAX VALUES ('resto_cond_elemental','LIKE',214);
--215:      |   resto_fcond
INSERT INTO PRODUCCIONES VALUES (215,1,'resto_fcond','N');
INSERT INTO TABLA_SINTAX VALUES ('resto_cond_elemental','FEQ',215);
INSERT INTO TABLA_SINTAX VALUES ('resto_cond_elemental','FGT',215);
INSERT INTO TABLA_SINTAX VALUES ('resto_cond_elemental','FLT',215);
INSERT INTO TABLA_SINTAX VALUES ('resto_cond_elemental','FGEQ',215);
INSERT INTO TABLA_SINTAX VALUES ('resto_cond_elemental','FLEQ',215);
INSERT INTO TABLA_SINTAX VALUES ('resto_cond_elemental','MGT',215);
INSERT INTO TABLA_SINTAX VALUES ('resto_cond_elemental','MLT',215);
INSERT INTO TABLA_SINTAX VALUES ('resto_cond_elemental','NFEQ',215);
INSERT INTO TABLA_SINTAX VALUES ('resto_cond_elemental','NFGT',215);
INSERT INTO TABLA_SINTAX VALUES ('resto_cond_elemental','NFLT',215);
INSERT INTO TABLA_SINTAX VALUES ('resto_cond_elemental','NFGEQ',215);
INSERT INTO TABLA_SINTAX VALUES ('resto_cond_elemental','NFLEQ',215);
INSERT INTO TABLA_SINTAX VALUES ('resto_cond_elemental','NMGT',215);
INSERT INTO TABLA_SINTAX VALUES ('resto_cond_elemental','NMLT',215);
--216:      |   IS negacion fuzzy_ctes
INSERT INTO PRODUCCIONES VALUES (216,1,'IS','T');
INSERT INTO PRODUCCIONES VALUES (216,2,'negacion','N');
INSERT INTO PRODUCCIONES VALUES (216,3,'fuzzy_ctes','N');
INSERT INTO TABLA_SINTAX VALUES ('resto_cond_elemental','IS',216);
--217:      |
INSERT INTO PRODUCCIONES VALUES (217,1,'VACIO','N');
INSERT INTO TABLA_SINTAX VALUES ('resto_cond_elemental',FIN,217);
INSERT INTO TABLA_SINTAX VALUES ('resto_cond_elemental',';',217);
INSERT INTO TABLA_SINTAX VALUES ('resto_cond_elemental','AND',217);
INSERT INTO TABLA_SINTAX VALUES ('resto_cond_elemental','OR',217);
INSERT INTO TABLA_SINTAX VALUES ('resto_cond_elemental',')',217);
INSERT INTO TABLA_SINTAX VALUES ('resto_cond_elemental','}',217);
INSERT INTO TABLA_SINTAX VALUES ('resto_cond_elemental','GROUP',217);
INSERT INTO TABLA_SINTAX VALUES ('resto_cond_elemental','CONNECT',217);
INSERT INTO TABLA_SINTAX VALUES ('resto_cond_elemental','START',217);
INSERT INTO TABLA_SINTAX VALUES ('resto_cond_elemental','UNION',217);
INSERT INTO TABLA_SINTAX VALUES ('resto_cond_elemental','INTERSECT',217);
INSERT INTO TABLA_SINTAX VALUES ('resto_cond_elemental','MINUS',217);
INSERT INTO TABLA_SINTAX VALUES ('resto_cond_elemental','ORDER',217);

--218: resto_fcond: fcomparador fexpr umbral
INSERT INTO PRODUCCIONES VALUES (218,1,'fcomparador','N');
INSERT INTO PRODUCCIONES VALUES (218,2,'fexpr','N');
INSERT INTO PRODUCCIONES VALUES (218,3,'umbral','N');
INSERT INTO TABLA_SINTAX VALUES ('resto_fcond','FEQ',218);
INSERT INTO TABLA_SINTAX VALUES ('resto_fcond','FGT',218);
INSERT INTO TABLA_SINTAX VALUES ('resto_fcond','FLT',218);
INSERT INTO TABLA_SINTAX VALUES ('resto_fcond','FGEQ',218);
INSERT INTO TABLA_SINTAX VALUES ('resto_fcond','FLEQ',218);
INSERT INTO TABLA_SINTAX VALUES ('resto_fcond','MGT',218);
INSERT INTO TABLA_SINTAX VALUES ('resto_fcond','MLT',218);
INSERT INTO TABLA_SINTAX VALUES ('resto_fcond','NFEQ',218);
INSERT INTO TABLA_SINTAX VALUES ('resto_fcond','NFGT',218);
INSERT INTO TABLA_SINTAX VALUES ('resto_fcond','NFLT',218);
INSERT INTO TABLA_SINTAX VALUES ('resto_fcond','NFGEQ',218);
INSERT INTO TABLA_SINTAX VALUES ('resto_fcond','NFLEQ',218);
INSERT INTO TABLA_SINTAX VALUES ('resto_fcond','NMGT',218);
INSERT INTO TABLA_SINTAX VALUES ('resto_fcond','NMLT',218);

--220: umbral   :   THOLD NUMERO
INSERT INTO PRODUCCIONES VALUES (220,1,'THOLD','T');
INSERT INTO PRODUCCIONES VALUES (220,2,'NUMERO','T');
INSERT INTO TABLA_SINTAX VALUES ('umbral','THOLD',220);
--221:      |   NUMERO
INSERT INTO PRODUCCIONES VALUES (221,1,'NUMERO','T');
INSERT INTO TABLA_SINTAX VALUES ('umbral','NUMERO',221);
--222:      |   comparador NUMERO
INSERT INTO PRODUCCIONES VALUES (222,1,'comparador','N');
INSERT INTO PRODUCCIONES VALUES (222,2,'NUMERO','T');
INSERT INTO TABLA_SINTAX VALUES ('umbral','EQ',222);
INSERT INTO TABLA_SINTAX VALUES ('umbral','NEQ',222);
INSERT INTO TABLA_SINTAX VALUES ('umbral','LEQ',222);
INSERT INTO TABLA_SINTAX VALUES ('umbral','GEQ',222);
INSERT INTO TABLA_SINTAX VALUES ('umbral','LT',222);
INSERT INTO TABLA_SINTAX VALUES ('umbral','GT',222);
--223:      |
INSERT INTO PRODUCCIONES VALUES (223,1,'VACIO','N');
INSERT INTO TABLA_SINTAX VALUES ('umbral',FIN,223);
INSERT INTO TABLA_SINTAX VALUES ('umbral',';',223);
INSERT INTO TABLA_SINTAX VALUES ('umbral','AND',223);
INSERT INTO TABLA_SINTAX VALUES ('umbral','OR',223);
INSERT INTO TABLA_SINTAX VALUES ('umbral',')',223);
INSERT INTO TABLA_SINTAX VALUES ('umbral','}',223);
INSERT INTO TABLA_SINTAX VALUES ('umbral','GROUP',223);
INSERT INTO TABLA_SINTAX VALUES ('umbral','CONNECT',223);
INSERT INTO TABLA_SINTAX VALUES ('umbral','START',223);
INSERT INTO TABLA_SINTAX VALUES ('umbral','UNION',223);
INSERT INTO TABLA_SINTAX VALUES ('umbral','INTERSECT',223);
INSERT INTO TABLA_SINTAX VALUES ('umbral','MINUS',223);
INSERT INTO TABLA_SINTAX VALUES ('umbral','ORDER',223);

--224: negacion :   NOT
INSERT INTO PRODUCCIONES VALUES (224,1,'NOT','T');
INSERT INTO TABLA_SINTAX VALUES ('negacion','NOT',224);
--225:      |
INSERT INTO PRODUCCIONES VALUES (225,1,'VACIO','N');
INSERT INTO TABLA_SINTAX VALUES ('negacion','NULL',225);
INSERT INTO TABLA_SINTAX VALUES ('negacion','UNDEFINED',225);
INSERT INTO TABLA_SINTAX VALUES ('negacion','UNKNOWN',225);

--226: fexpr    :   '$' resto_fexpr
INSERT INTO PRODUCCIONES VALUES (226,1,'$','T');
INSERT INTO PRODUCCIONES VALUES (226,2,'resto_fexpr','N');
INSERT INTO TABLA_SINTAX VALUES ('fexpr','$',226);
--227:      |   '#' NUMERO
INSERT INTO PRODUCCIONES VALUES (227,1,'#','T');
INSERT INTO PRODUCCIONES VALUES (227,2,'NUMERO','T');
INSERT INTO TABLA_SINTAX VALUES ('fexpr','#',227);
--228:      |   '[' NUMERO ',' NUMERO ']'
INSERT INTO PRODUCCIONES VALUES (228,1,'[','T');
INSERT INTO PRODUCCIONES VALUES (228,2,'NUMERO','T');
INSERT INTO PRODUCCIONES VALUES (228,3,',','T');
INSERT INTO PRODUCCIONES VALUES (228,4,'NUMERO','T');
INSERT INTO PRODUCCIONES VALUES (228,5,']','T');
INSERT INTO TABLA_SINTAX VALUES ('fexpr','[',228);
--229:      |   expr
INSERT INTO PRODUCCIONES VALUES (229,1,'expr','N');
--Iniciales(expr)
INSERT INTO TABLA_SINTAX VALUES ('fexpr','+',229);
INSERT INTO TABLA_SINTAX VALUES ('fexpr','-',229);
INSERT INTO TABLA_SINTAX VALUES ('fexpr','PRIOR',229);
INSERT INTO TABLA_SINTAX VALUES ('fexpr','(',229);
INSERT INTO TABLA_SINTAX VALUES ('fexpr','{',229);
/* ctes */
INSERT INTO TABLA_SINTAX VALUES ('fexpr','NUMERO',229);
INSERT INTO TABLA_SINTAX VALUES ('fexpr','SYSDATE',229);
INSERT INTO TABLA_SINTAX VALUES ('fexpr','UID',229);
INSERT INTO TABLA_SINTAX VALUES ('fexpr','USER',229);
INSERT INTO TABLA_SINTAX VALUES ('fexpr','TEXTO',229);
INSERT INTO TABLA_SINTAX VALUES ('fexpr','LEVEL',229);
INSERT INTO TABLA_SINTAX VALUES ('fexpr','NULL',229);
INSERT INTO TABLA_SINTAX VALUES ('fexpr','UNDEFINED',229);
INSERT INTO TABLA_SINTAX VALUES ('fexpr','UNKNOWN',229);
/* columna */
INSERT INTO TABLA_SINTAX VALUES ('fexpr','ID',229);
INSERT INTO TABLA_SINTAX VALUES ('fexpr','ROWID',229);
INSERT INTO TABLA_SINTAX VALUES ('fexpr','ROWNUM',229);
/* funciones */
INSERT INTO TABLA_SINTAX VALUES ('fexpr','ABS',229);
INSERT INTO TABLA_SINTAX VALUES ('fexpr','CDEG',229);
INSERT INTO TABLA_SINTAX VALUES ('fexpr','CEIL',229);
INSERT INTO TABLA_SINTAX VALUES ('fexpr','FLOOR',229);
INSERT INTO TABLA_SINTAX VALUES ('fexpr','SIGN',229);
INSERT INTO TABLA_SINTAX VALUES ('fexpr','SQRT',229);
INSERT INTO TABLA_SINTAX VALUES ('fexpr','CHR',229);
INSERT INTO TABLA_SINTAX VALUES ('fexpr','MOD',229);
INSERT INTO TABLA_SINTAX VALUES ('fexpr','POWER',229);
INSERT INTO TABLA_SINTAX VALUES ('fexpr','INITCAP',229);
INSERT INTO TABLA_SINTAX VALUES ('fexpr','LOWER',229);
INSERT INTO TABLA_SINTAX VALUES ('fexpr','LPAD',229);
INSERT INTO TABLA_SINTAX VALUES ('fexpr','LTRIM',229);
INSERT INTO TABLA_SINTAX VALUES ('fexpr','REPLACE',229);
INSERT INTO TABLA_SINTAX VALUES ('fexpr','RPAD',229);
INSERT INTO TABLA_SINTAX VALUES ('fexpr','RTRIM',229);
INSERT INTO TABLA_SINTAX VALUES ('fexpr','SOUNDEX',229);
INSERT INTO TABLA_SINTAX VALUES ('fexpr','SUBSTR',229);
INSERT INTO TABLA_SINTAX VALUES ('fexpr','TRANSLATE',229);
INSERT INTO TABLA_SINTAX VALUES ('fexpr','UPPER',229);
INSERT INTO TABLA_SINTAX VALUES ('fexpr','ASCII',229);
INSERT INTO TABLA_SINTAX VALUES ('fexpr','INSTR',229);
INSERT INTO TABLA_SINTAX VALUES ('fexpr','LENGTH',229);
INSERT INTO TABLA_SINTAX VALUES ('fexpr','NLSSORT',229);
INSERT INTO TABLA_SINTAX VALUES ('fexpr','AVG',229);
INSERT INTO TABLA_SINTAX VALUES ('fexpr','COUNT',229);
INSERT INTO TABLA_SINTAX VALUES ('fexpr','MAX',229);
INSERT INTO TABLA_SINTAX VALUES ('fexpr','MIN',229);
INSERT INTO TABLA_SINTAX VALUES ('fexpr','STDDEV',229);
INSERT INTO TABLA_SINTAX VALUES ('fexpr','SUM',229);
INSERT INTO TABLA_SINTAX VALUES ('fexpr','VARIANCE',229);
INSERT INTO TABLA_SINTAX VALUES ('fexpr','CHARTOROWID',229);
INSERT INTO TABLA_SINTAX VALUES ('fexpr','CONVERT',229);
INSERT INTO TABLA_SINTAX VALUES ('fexpr','HEXTORAW',229);
INSERT INTO TABLA_SINTAX VALUES ('fexpr','RAWTOHEX',229);
INSERT INTO TABLA_SINTAX VALUES ('fexpr','ROWIDTOCHAR',229);
INSERT INTO TABLA_SINTAX VALUES ('fexpr','TO_CHAR',229);
INSERT INTO TABLA_SINTAX VALUES ('fexpr','TO_DATE',229);
INSERT INTO TABLA_SINTAX VALUES ('fexpr','TO_NUMBER',229);
INSERT INTO TABLA_SINTAX VALUES ('fexpr','ADD_MONTHS',229);
INSERT INTO TABLA_SINTAX VALUES ('fexpr','LAST_DAY',229);
INSERT INTO TABLA_SINTAX VALUES ('fexpr','MONTHS_BETWEEN',229);
INSERT INTO TABLA_SINTAX VALUES ('fexpr','NEW_TIME',229);
INSERT INTO TABLA_SINTAX VALUES ('fexpr','NEXT_DAY',229);
INSERT INTO TABLA_SINTAX VALUES ('fexpr','ROUND',229);
INSERT INTO TABLA_SINTAX VALUES ('fexpr','TRUNC',229);
INSERT INTO TABLA_SINTAX VALUES ('fexpr','DUMP',229);
INSERT INTO TABLA_SINTAX VALUES ('fexpr','GREATEST',229);
INSERT INTO TABLA_SINTAX VALUES ('fexpr','LEAST',229);
INSERT INTO TABLA_SINTAX VALUES ('fexpr','NVL',229);
INSERT INTO TABLA_SINTAX VALUES ('fexpr','USERENV',229);
INSERT INTO TABLA_SINTAX VALUES ('fexpr','VSIZE',229);
INSERT INTO TABLA_SINTAX VALUES ('fexpr','DECODE',229);

--230: resto_fexpr  :   ID
INSERT INTO PRODUCCIONES VALUES (230,1,'ID','T');
INSERT INTO TABLA_SINTAX VALUES ('resto_fexpr','ID',230);
--231:      |   '[' NUMERO ',' NUMERO ',' NUMERO ',' NUMERO ']'
INSERT INTO PRODUCCIONES VALUES (231,1,'[','T');
INSERT INTO PRODUCCIONES VALUES (231,2,'NUMERO','T');
INSERT INTO PRODUCCIONES VALUES (231,3,',','T');
INSERT INTO PRODUCCIONES VALUES (231,4,'NUMERO','T');
INSERT INTO PRODUCCIONES VALUES (231,5,',','T');
INSERT INTO PRODUCCIONES VALUES (231,6,'NUMERO','T');
INSERT INTO PRODUCCIONES VALUES (231,7,',','T');
INSERT INTO PRODUCCIONES VALUES (231,8,'NUMERO','T');
INSERT INTO PRODUCCIONES VALUES (231,9,']','T');
INSERT INTO TABLA_SINTAX VALUES ('resto_fexpr','[',231);

-- Comparadores difusos de Posibilidad:
--232/238: fcomparador  :   FEQ | FGT | FLT | FGEQ | FLEQ | MGT | MLT
INSERT INTO PRODUCCIONES VALUES (232,1,'FEQ','T');
INSERT INTO PRODUCCIONES VALUES (233,1,'FGT','T');
INSERT INTO PRODUCCIONES VALUES (234,1,'FLT','T');
INSERT INTO PRODUCCIONES VALUES (235,1,'FGEQ','T');
INSERT INTO PRODUCCIONES VALUES (236,1,'FLEQ','T');
INSERT INTO PRODUCCIONES VALUES (237,1,'MGT','T');
INSERT INTO PRODUCCIONES VALUES (238,1,'MLT','T');
INSERT INTO TABLA_SINTAX VALUES ('fcomparador','FEQ',232);
INSERT INTO TABLA_SINTAX VALUES ('fcomparador','FGT',233);
INSERT INTO TABLA_SINTAX VALUES ('fcomparador','FLT',234);
INSERT INTO TABLA_SINTAX VALUES ('fcomparador','FGEQ',235);
INSERT INTO TABLA_SINTAX VALUES ('fcomparador','FLEQ',236);
INSERT INTO TABLA_SINTAX VALUES ('fcomparador','MGT',237);
INSERT INTO TABLA_SINTAX VALUES ('fcomparador','MLT',238);

-- Comparadores difusos de Necesidad:
--501/507: fcomparador  :   NFEQ | NFGT | NFLT | NFGEQ | NFLEQ | NMGT | NMLT
INSERT INTO PRODUCCIONES VALUES (501,1,'NFEQ','T');
INSERT INTO PRODUCCIONES VALUES (502,1,'NFGT','T');
INSERT INTO PRODUCCIONES VALUES (503,1,'NFLT','T');
INSERT INTO PRODUCCIONES VALUES (504,1,'NFGEQ','T');
INSERT INTO PRODUCCIONES VALUES (505,1,'NFLEQ','T');
INSERT INTO PRODUCCIONES VALUES (506,1,'NMGT','T');
INSERT INTO PRODUCCIONES VALUES (507,1,'NMLT','T');
INSERT INTO TABLA_SINTAX VALUES ('fcomparador','NFEQ',501);
INSERT INTO TABLA_SINTAX VALUES ('fcomparador','NFGT',502);
INSERT INTO TABLA_SINTAX VALUES ('fcomparador','NFLT',503);
INSERT INTO TABLA_SINTAX VALUES ('fcomparador','NFGEQ',504);
INSERT INTO TABLA_SINTAX VALUES ('fcomparador','NFLEQ',505);
INSERT INTO TABLA_SINTAX VALUES ('fcomparador','NMGT',506);
INSERT INTO TABLA_SINTAX VALUES ('fcomparador','NMLT',507);

--240/242: fuzzy_ctes   :   NULL | UNDEFINED | UNKNOWN
INSERT INTO PRODUCCIONES VALUES (240,1,'NULL','T');
INSERT INTO PRODUCCIONES VALUES (241,1,'UNDEFINED','T');
INSERT INTO PRODUCCIONES VALUES (242,1,'UNKNOWN','T');
INSERT INTO TABLA_SINTAX VALUES ('fuzzy_ctes','NULL',240);
INSERT INTO TABLA_SINTAX VALUES ('fuzzy_ctes','UNDEFINED',241);
INSERT INTO TABLA_SINTAX VALUES ('fuzzy_ctes','UNKNOWN',242);

--250: resto_nofcond:   comparador expr
INSERT INTO PRODUCCIONES VALUES (250,1,'comparador','N');
INSERT INTO PRODUCCIONES VALUES (250,2,'expr','N');
INSERT INTO TABLA_SINTAX VALUES ('resto_nofcond','EQ',250);
INSERT INTO TABLA_SINTAX VALUES ('resto_nofcond','NEQ',250);
INSERT INTO TABLA_SINTAX VALUES ('resto_nofcond','LEQ',250);
INSERT INTO TABLA_SINTAX VALUES ('resto_nofcond','GEQ',250);
INSERT INTO TABLA_SINTAX VALUES ('resto_nofcond','LT',250);
INSERT INTO TABLA_SINTAX VALUES ('resto_nofcond','GT',250);
--251:      |   cond_entre
INSERT INTO PRODUCCIONES VALUES (251,1,'cond_entre','N');
INSERT INTO TABLA_SINTAX VALUES ('resto_nofcond','BETWEEN',251);
--252:      |   cond_in
INSERT INTO PRODUCCIONES VALUES (252,1,'cond_in','N');
INSERT INTO TABLA_SINTAX VALUES ('resto_nofcond','IN',252);
--253:      |   NOT cond_entrein
INSERT INTO PRODUCCIONES VALUES (253,1,'NOT','T');
INSERT INTO PRODUCCIONES VALUES (253,2,'cond_entrein','N');
INSERT INTO TABLA_SINTAX VALUES ('resto_nofcond','NOT',253);
--254:      |   LIKE TEXTO
INSERT INTO PRODUCCIONES VALUES (254,1,'LIKE','T');
INSERT INTO PRODUCCIONES VALUES (254,2,'TEXTO','T');
INSERT INTO TABLA_SINTAX VALUES ('resto_nofcond','LIKE',254);

--255: cond_entre   :   BETWEEN expr AND expr
INSERT INTO PRODUCCIONES VALUES (255,1,'BETWEEN','T');
INSERT INTO PRODUCCIONES VALUES (255,2,'expr','N');
INSERT INTO PRODUCCIONES VALUES (255,3,'AND','T');
INSERT INTO PRODUCCIONES VALUES (255,4,'expr','N');
INSERT INTO TABLA_SINTAX VALUES ('cond_entre','BETWEEN',255);

--256: cond_in  :   IN arg_list
INSERT INTO PRODUCCIONES VALUES (256,1,'IN','T');
INSERT INTO PRODUCCIONES VALUES (256,2,'arg_list','N');
INSERT INTO TABLA_SINTAX VALUES ('cond_in','IN',256);

--257: cond_entrein:    cond_entre
INSERT INTO PRODUCCIONES VALUES (257,1,'cond_entre','N');
INSERT INTO TABLA_SINTAX VALUES ('cond_entrein','BETWEEN',257);
--258:      |   cond_in
INSERT INTO PRODUCCIONES VALUES (258,1,'cond_in','N');
INSERT INTO TABLA_SINTAX VALUES ('cond_entrein','IN',258);
--259:      |   LIKE TEXTO
INSERT INTO PRODUCCIONES VALUES (259,1,'LIKE','T');
INSERT INTO PRODUCCIONES VALUES (259,2,'TEXTO','T');
INSERT INTO TABLA_SINTAX VALUES ('cond_entrein','LIKE',259);

--260/265: comparador   :   EQ | NEQ | LEQ | GEQ | LT | GT
INSERT INTO PRODUCCIONES VALUES (260,1,'EQ','T');
INSERT INTO PRODUCCIONES VALUES (261,1,'NEQ','T');
INSERT INTO PRODUCCIONES VALUES (262,1,'LEQ','T');
INSERT INTO PRODUCCIONES VALUES (263,1,'GEQ','T');
INSERT INTO PRODUCCIONES VALUES (264,1,'LT','T');
INSERT INTO PRODUCCIONES VALUES (265,1,'GT','T');
INSERT INTO TABLA_SINTAX VALUES ('comparador','EQ',260);
INSERT INTO TABLA_SINTAX VALUES ('comparador','NEQ',261);
INSERT INTO TABLA_SINTAX VALUES ('comparador','LEQ',262);
INSERT INTO TABLA_SINTAX VALUES ('comparador','GEQ',263);
INSERT INTO TABLA_SINTAX VALUES ('comparador','LT',264);
INSERT INTO TABLA_SINTAX VALUES ('comparador','GT',265);

/*****> Definicin de otras de clusulas del SELECT <*****/
--270: clausula_variante:GROUP BY expr mas_expres clausula_having clausula_variante
INSERT INTO PRODUCCIONES VALUES (270,1,'GROUP','T');
INSERT INTO PRODUCCIONES VALUES (270,2,'BY','T');
INSERT INTO PRODUCCIONES VALUES (270,3,'expr','N');
INSERT INTO PRODUCCIONES VALUES (270,4,'mas_expres','N');
INSERT INTO PRODUCCIONES VALUES (270,5,'clausula_having','N');
INSERT INTO PRODUCCIONES VALUES (270,6,'clausula_variante','N');
INSERT INTO TABLA_SINTAX VALUES ('clausula_variante','GROUP',270);
--271:  |       clausula_start CONNECT BY condition clausula_variante
INSERT INTO PRODUCCIONES VALUES (271,1,'clausula_start','N');
INSERT INTO PRODUCCIONES VALUES (271,2,'CONNECT','T');
INSERT INTO PRODUCCIONES VALUES (271,3,'BY','T');
INSERT INTO PRODUCCIONES VALUES (271,4,'condition','N');
INSERT INTO PRODUCCIONES VALUES (271,5,'clausula_variante','N');
INSERT INTO TABLA_SINTAX VALUES ('clausula_variante','START',271);
INSERT INTO TABLA_SINTAX VALUES ('clausula_variante','CONNECT',271);
--272:  |
INSERT INTO PRODUCCIONES VALUES (272,1,'VACIO','N');
INSERT INTO TABLA_SINTAX VALUES ('clausula_variante',FIN,272);
INSERT INTO TABLA_SINTAX VALUES ('clausula_variante',';',272);
INSERT INTO TABLA_SINTAX VALUES ('clausula_variante','UNION',272);
INSERT INTO TABLA_SINTAX VALUES ('clausula_variante','INTERSECT',272);
INSERT INTO TABLA_SINTAX VALUES ('clausula_variante','MINUS',272);
INSERT INTO TABLA_SINTAX VALUES ('clausula_variante','ORDER',272);
INSERT INTO TABLA_SINTAX VALUES ('clausula_variante',')',272);

--273: clausula_start:  START WITH condition
INSERT INTO PRODUCCIONES VALUES (273,1,'START','T');
INSERT INTO PRODUCCIONES VALUES (273,2,'BY','T');
INSERT INTO PRODUCCIONES VALUES (273,3,'condition','N');
INSERT INTO TABLA_SINTAX VALUES ('clausula_start','START',273);
--274:  |
INSERT INTO PRODUCCIONES VALUES (274,1,'VACIO','N');
INSERT INTO TABLA_SINTAX VALUES ('clausula_start','CONNECT',274);

--275: clausula_having: HAVING condition
INSERT INTO PRODUCCIONES VALUES (275,1,'HAVING','T');
INSERT INTO PRODUCCIONES VALUES (275,2,'condition','N');
INSERT INTO TABLA_SINTAX VALUES ('clausula_having','HAVING',275);
--276:  |
INSERT INTO PRODUCCIONES VALUES (276,1,'VACIO','N');
INSERT INTO TABLA_SINTAX VALUES ('clausula_having',FIN,276);
INSERT INTO TABLA_SINTAX VALUES ('clausula_having',';',276);
INSERT INTO TABLA_SINTAX VALUES ('clausula_having','GROUP',276);
INSERT INTO TABLA_SINTAX VALUES ('clausula_having','CONNECT',276);
INSERT INTO TABLA_SINTAX VALUES ('clausula_having','START',276);
INSERT INTO TABLA_SINTAX VALUES ('clausula_having','UNION',276);
INSERT INTO TABLA_SINTAX VALUES ('clausula_having','INTERSECT',276);
INSERT INTO TABLA_SINTAX VALUES ('clausula_having','MINUS',276);
INSERT INTO TABLA_SINTAX VALUES ('clausula_having','ORDER',276);
INSERT INTO TABLA_SINTAX VALUES ('clausula_having',')',276);

--280: clausula_orden:  ORDER BY expr ordenacion resto_l_orden clausula_orden
INSERT INTO PRODUCCIONES VALUES (280,1,'ORDER','T');
INSERT INTO PRODUCCIONES VALUES (280,2,'BY','T');
INSERT INTO PRODUCCIONES VALUES (280,3,'expr','N');
INSERT INTO PRODUCCIONES VALUES (280,4,'ordenacion','N');
INSERT INTO PRODUCCIONES VALUES (280,5,'resto_l_orden','N');
INSERT INTO PRODUCCIONES VALUES (280,6,'clausula_orden','N');
INSERT INTO TABLA_SINTAX VALUES ('clausula_orden','ORDER',280);
--281:  |
INSERT INTO PRODUCCIONES VALUES (281,1,'VACIO','N');
INSERT INTO TABLA_SINTAX VALUES ('clausula_orden',FIN,281);
INSERT INTO TABLA_SINTAX VALUES ('clausula_orden',';',281);
INSERT INTO TABLA_SINTAX VALUES ('clausula_orden',')',281);

--282: resto_l_orden:   ',' expr ordenacion resto_l_orden
INSERT INTO PRODUCCIONES VALUES (282,1,',','T');
INSERT INTO PRODUCCIONES VALUES (282,2,'expr','N');
INSERT INTO PRODUCCIONES VALUES (282,3,'ordenacion','N');
INSERT INTO PRODUCCIONES VALUES (282,4,'resto_l_orden','N');
INSERT INTO TABLA_SINTAX VALUES ('resto_l_orden',',',282);
--283:  |
INSERT INTO PRODUCCIONES VALUES (283,1,'VACIO','N');
INSERT INTO TABLA_SINTAX VALUES ('resto_l_orden',FIN,283);
INSERT INTO TABLA_SINTAX VALUES ('resto_l_orden',';',283);
INSERT INTO TABLA_SINTAX VALUES ('resto_l_orden','ORDER',283);
INSERT INTO TABLA_SINTAX VALUES ('resto_l_orden',')',283);

--284/285: ordenacion   :   ASC | DESC
INSERT INTO PRODUCCIONES VALUES (284,1,'ASC','T');
INSERT INTO PRODUCCIONES VALUES (285,1,'DESC','T');
INSERT INTO TABLA_SINTAX VALUES ('ordenacion','ASC',284);
INSERT INTO TABLA_SINTAX VALUES ('ordenacion','DESC',285);
--286:  |
INSERT INTO PRODUCCIONES VALUES (286,1,'VACIO','N');
INSERT INTO TABLA_SINTAX VALUES ('ordenacion',FIN,286);
INSERT INTO TABLA_SINTAX VALUES ('ordenacion',';',286);
INSERT INTO TABLA_SINTAX VALUES ('ordenacion',',',286);
INSERT INTO TABLA_SINTAX VALUES ('ordenacion','ORDER',286);
INSERT INTO TABLA_SINTAX VALUES ('ordenacion',')',286);

COMMIT;
END;
/

-- Vista que contiene las tablas o vistas accesibles por el usuario: ACCESSIBLE_TABLES
-- (Aade el campo OBJ# con el OBJECT_ID de la tabla en cuestin)
-- Usada por el A. Semntico.
-- En versiones anteriores a Oracle 8 el atributo o.type# puede llamarse o.type
exec dbms_output.put_line('>>>> Creando vista ACCESSIBLE_TABLES y sus comentarios...');
create or replace view ACCESSIBLE_TABLES
    (OWNER, OBJ#, TABLE_NAME, TABLE_TYPE) as
select u.name, o.obj#, o.name,
       decode(o.type#, 2, 'TABLE', 4, 'VIEW')
from sys.user$ u, sys.obj$ o
where o.owner# = u.user#
  and o.linkname is null
  and o.type# in (2, 4)
  and (o.owner# = uid
       or
       obj# in (select obj#
                from sys.objauth$
                where grantee# in (select kzsrorol from x$kzsro)
                      or grantee#=uid
               )
      );

drop public synonym ACCESSIBLE_TABLES;
create public synonym ACCESSIBLE_TABLES for ACCESSIBLE_TABLES;
grant select on ACCESSIBLE_TABLES to PUBLIC with grant option;

comment on table  ACCESSIBLE_TABLES is 'Tables and Views accessible to the user';
comment on column ACCESSIBLE_TABLES.OWNER is 'Owner of the object';
comment on column ACCESSIBLE_TABLES.TABLE_NAME is 'Name of the object';
comment on column ACCESSIBLE_TABLES.TABLE_TYPE is 'Type of the object';
comment on column ACCESSIBLE_TABLES.OBJ# is 'ID number of the object';


-- --------------------------------------------------------------------------------------------
-- Paquetes PL/SQL del Servidor FSQL
-- --------------------------------------------------------------------------------------------
exec dbms_output.put_line('>>>> Crear paquetes del Servidor FSQL: FSQL_AUX, FSQL_SEMANTIC y FSQL_PKG');
exec dbms_output.put_line('>>>> Creando FSQL_AUX...');
@FSQL_AUX -- Paquete FSQL_AUX: Funciones tiles para el servidor
sho err
exec dbms_output.put_line('>>>> Creando FSQL_SEMANTIC...');
@FSQL_SEM -- Paquete FSQL_SEMANTIC: Analizador Semntico y conversor del Servidor FSQL
sho err
exec dbms_output.put_line('>>>> Creando FSQL_PKG...');
@FSQL_PKG -- Paquete FSQL_PKG, Servidor FSQL: Funcin FSQL2SQL, Procedimiento FSQL_FIN y otros tiles
sho err

exec dbms_output.put_line('>>>> Crear paquetes de comparacin difusa: FSQL_FUNCTIONS y FSQL_FUNCTIONS2');
exec dbms_output.put_line('>>>> Creando FSQL_FUNCTIONS...');
@FSQL_F   -- Paquete FSQL_FUNCTIONS : Funciones de comparacin difusas
sho err
exec dbms_output.put_line('>>>> Creando FSQL_FUNCTIONS2...');
@FSQL_F2  -- Paquete FSQL_FUNCTIONS2: Funciones de comparacin difusas (Mucho)
sho err

exec dbms_output.put_line('>>>> Creando sinnimos y permisos para los paquetes...');
drop public synonym FSQL_PKG;
CREATE PUBLIC SYNONYM FSQL_PKG FOR FSQL_PKG;
GRANT EXECUTE on FSQL_PKG to PUBLIC;
drop public synonym FSQL_FUNCTIONS;
CREATE PUBLIC SYNONYM FSQL_FUNCTIONS FOR FSQL_FUNCTIONS;
GRANT EXECUTE on FSQL_FUNCTIONS to PUBLIC;
drop public synonym FSQL_FUNCTIONS2;
CREATE PUBLIC SYNONYM FSQL_FUNCTIONS2 FOR FSQL_FUNCTIONS2;
GRANT EXECUTE on FSQL_FUNCTIONS2 to PUBLIC;

exec dbms_output.put_line('>>>> Insertando comentarios de las tablas del Servidor FSQL que pueden ser consultados en');
exec dbms_output.put_line('>>>>   las vistas ALL_TAB_COMMENTS, ALL_COL_COMMENTS, USER_TAB_COMMENTS...');
-- COMENTARIOS: Se almacenan en las vistas ALL_TAB_COMMENTS, ALL_COL_COMMENTS, USER_TAB_COMMENTS
-- Comentarios sobre las tablas del Servidor FSQL:
comment on table T_TRANSI is
'Transiciones del Autmata del Analizador Lxico';
comment on table RESERVADAS is
'Palabras Reservadas de la gramtica de consultas FSQL para el A. Sintctico';
comment on table TABLA_SINTAX is
'Transiciones de la Gramtica de consultas FSQL para el A. Sintctico';
comment on table PRODUCCIONES is
'Producciones de la Gramtica de consultas FSQL para el A. Sintctico';
comment on table FSQL_ALL_ERRORS is
'Mensajes de los Errores FSQL cometidos en la consulta de la sesin SESSIONID';
comment on table FSQL_ALL_QUERIES is
'Consultas: FSQL y su traduccin SQL. Concatenar columna ATRIBUTO';
-- Comentarios sobre las columnas de la tabla FSQL_ALL_ERRORS
comment on column FSQL_ALL_ERRORS.SESSIONID is
'Identifica la sesin en la que se cometi el error de esa tupla';
comment on column FSQL_ALL_ERRORS.INDICE is
'Nmero del error cometido en la sesin SESSIONID';
comment on column FSQL_ALL_ERRORS.MSG_ERROR is
'Mensaje del error cometido en la sesin SESSIONID';
-- Comentarios sobre las columnas de las tabla FSQL_ALL_QUERIES
comment on column FSQL_ALL_QUERIES.SESSIONID is
'Identifica la sesin que est usando esa tupla';
comment on column FSQL_ALL_QUERIES.INDICE is
'Ordena las diferentes partes de las que se compone la consulta';
comment on column FSQL_ALL_QUERIES.ATRIBUTO is
'Parte de una consulta FSQL: El Cliente FSQL concatenar esta columna ordenadas por INDICE';
comment on column FSQL_ALL_QUERIES.POSICION is
'Posicin de esta parte en la consulta (para los msgs de error)';
comment on column FSQL_ALL_QUERIES.NOMBRE is
'Nombre de cada parte (para uso del Servidor FSQL)';

-- Los mismos comentarios pero sobre las vistas del Servidor FSQL, a las que accede el usuario:
comment on table FSQL_ERRORS is
'Mensajes de los Errores FSQL cometidos en la consulta de la sesin SESSIONID';
comment on table FSQL_QUERY is
'Consultas: FSQL y su traduccin SQL. Concatenar columna ATRIBUTO';
-- Comentarios sobre las columnas de la vista FSQL_ERRORS
comment on column FSQL_ERRORS.SESSIONID is
'Identifica la sesin en la que se cometi el error de esa tupla';
comment on column FSQL_ERRORS.INDICE is
'Nmero del error cometido en la sesin SESSIONID';
comment on column FSQL_ERRORS.MSG_ERROR is
'Mensaje del error cometido en la sesin SESSIONID';
-- Comentarios sobre las columnas de las vista FSQL_QUERY
comment on column FSQL_QUERY.SESSIONID is
'Identifica la sesin que est usando esa tupla';
comment on column FSQL_QUERY.INDICE is
'Ordena las diferentes partes de las que se compone la consulta';
comment on column FSQL_QUERY.ATRIBUTO is
'Parte de una consulta FSQL: El Cliente FSQL concatenar esta columna ordenadas por INDICE';
comment on column FSQL_QUERY.POSICION is
'Posicin de esta parte en la consulta (para los msgs de error)';
comment on column FSQL_QUERY.NOMBRE is
'Nombre de cada parte (para uso del Servidor FSQL)';

-- Comentarios sobre la vista FSQL_OPTIONS
comment on table FSQL_OPTIONS is
'Vista con diversas opciones de configuracin del usuario: funciones para los operadores lgicos, tratamiento de atributos difusos...';
-- Comentarios sobre las columnas de la vista FSQL_ERRORS
comment on column FSQL_OPTIONS.OWNER is
'Identifica el usuario que cambia o posee la opcin de configuracin.';
comment on column FSQL_OPTIONS.OPCION is
'Opcin que se configura: NOT, AND, OR, TRATA_FUZZY_ATRIB...';
comment on column FSQL_OPTIONS.VALOR is 'Valor que se le da a la opcin';

-- Comentarios sobre la vista FSQL_INFO
comment on table FSQL_INFO is
'Vista con informacin general del Servidor FSQL';
-- Comentarios sobre las columnas de la vista FSQL_ERRORS
comment on column FSQL_INFO.OPCION is
'Opcin sobre la que se facilita la informacin: VERSION, FECHA...';
comment on column FSQL_INFO.VALOR is 'Informacin sobre la opcin';

-- Mostrar algunos objetos creados y su estado (VALID/INVALID):
-- SELECT object_name, object_type, status FROM ALL_OBJECTS
-- WHERE object_name like 'FSQL%'
-- AND object_type='PACKAGE';

-- Mensaje de FIN:
exec dbms_output.put_line('>>>>');
exec dbms_output.put_line('>>>> FIN de la INSTALACIN: Si existieron errores, revise su texto.');
exec dbms_output.put_line('>>>>');

-- Reestablecer los valores por defecto:
set serveroutput off
set feedback on
